/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.models.base.ASaltarT2;
import hellfirepvp.astralsorcery.client.models.base.ASaltarT3;
import hellfirepvp.astralsorcery.client.render.tile.TESRCollectorCrystal;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import org.lwjgl.opengl.GL11;

public class TESRAltar
extends TileEntitySpecialRenderer<TileAltar> {
    private static final Random rand = new Random();
    private static final ASaltarT2 modelAltar2 = new ASaltarT2();
    private static final BindableResource texAltar2 = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "base/altarT2");
    private static final ASaltarT3 modelAltar3 = new ASaltarT3();
    private static final BindableResource texAltar3 = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "base/altarT3");

    public void renderTileEntityAt(TileAltar te, double x, double y, double z, float partialTicks, int destroyStage) {
        long sBase = 7553015156732193565L;
        sBase ^= (long)te.func_174877_v().func_177958_n();
        sBase ^= (long)te.func_174877_v().func_177956_o();
        sBase ^= (long)te.func_174877_v().func_177952_p();
        double jBase = (float)ClientScheduler.getClientTick() + partialTicks;
        jBase /= 20.0;
        switch (te.getAltarLevel()) {
            case ATTUNEMENT: {
                this.renderT2Additions(te, x, y, z, jBase);
                break;
            }
            case CONSTELLATION_CRAFT: {
                this.renderT3Additions(te, x, y, z, jBase);
                if (!te.getMultiblockState()) break;
                GL11.glPushMatrix();
                this.renderCrystalEffects(te, x, y, z, partialTicks, sBase);
                this.renderFocusLens(te, x, y, z, partialTicks);
                GL11.glPopMatrix();
                break;
            }
            case TRAIT_CRAFT: {
                if (!te.getMultiblockState()) break;
                IConstellation c = te.getFocusedConstellation();
                if (c != null) {
                    GL11.glPushMatrix();
                    float alphaDaytime = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(te.func_145831_w());
                    alphaDaytime *= 0.8f;
                    int max = 5000;
                    int t = (int)(ClientScheduler.getClientTick() % (long)max);
                    float halfAge = (float)max / 2.0f;
                    float tr = 1.0f - Math.abs(halfAge - (float)t) / halfAge;
                    RenderingUtils.removeStandartTranslationFromTESRMatrix(partialTicks);
                    float br = 0.9f * alphaDaytime;
                    RenderConstellation.renderConstellationIntoWorldFlat(c, c.getRenderColor(), new Vector3(te).add(0.5, 0.03, 0.5), 5.0f + (tr *= 2.0f), 2.0, 0.1f + br);
                    GL11.glPopMatrix();
                }
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 0.5), (double)(y + 4.0), (double)(z + 0.5));
                RenderingUtils.renderLightRayEffects(0.0, 0.5, 0.0, Color.YELLOW, 305223265L, ClientScheduler.getClientTick(), 20, 2.0f, 50, 25);
                RenderingUtils.renderLightRayEffects(0.0, 0.5, 0.0, Color.BLUE, 0L, ClientScheduler.getClientTick(), 10, 1.0f, 40, 25);
                TESRCollectorCrystal.renderCrystal(false, true);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                SpriteSheetResource ssr = SpriteLibrary.spriteHalo2;
                ssr.getResource().bind();
                GL11.glEnable((int)3042);
                GL11.glDisable((int)3008);
                Tuple<Double, Double> uv = ssr.getUVOffset(ClientScheduler.getClientTick());
                RenderingUtils.renderAngleRotatedTexturedRect(new Vector3(te).add(0.5, 0.06, 0.5), Vector3.RotAxis.Y_AXIS, 0.0, 5.0, (Double)uv.key, (Double)uv.value, ssr.getULength(), ssr.getVLength(), partialTicks);
                TextureHelper.refreshTextureBindState();
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
        }
    }

    private void renderT3Additions(TileAltar te, double x, double y, double z, double jump) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        RenderHelper.func_74518_a();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0625);
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
        texAltar3.bind();
        modelAltar3.func_78088_a(null, (float)jump, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderT2Additions(TileAltar te, double x, double y, double z, double jump) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0625);
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
        texAltar2.bind();
        modelAltar2.func_78088_a(null, (float)jump, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderFocusLens(TileAltar te, double x, double y, double z, float partialTicks) {
    }

    private void renderCrystalEffects(TileAltar te, double x, double y, double z, float partialTicks, long sBase) {
    }
}

