/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.sky;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class RenderDefaultSkybox
extends IRenderHandler {
    private static VertexBuffer skyVBO;
    private static VertexBuffer sky2VBO;
    private static VertexBuffer starVBO;
    private static int starGLCallList;
    private static int glSkyList;
    private static int glSkyList2;
    private static VertexFormat vertexBufferFormat;
    private static final ResourceLocation MC_DEF_SUN_PNG;
    private static final ResourceLocation MC_DEF_MOON_PHASES_PNG;

    public static void setupDefaultSkybox() {
        vertexBufferFormat = new VertexFormat();
        vertexBufferFormat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
        Tessellator tessellator = Tessellator.func_178181_a();
        net.minecraft.client.renderer.VertexBuffer vb = tessellator.func_178180_c();
        RenderDefaultSkybox.setupStars(vb);
        RenderDefaultSkybox.setupSky1(vb);
        RenderDefaultSkybox.setupSky2(vb);
    }

    private static void setupSky2(net.minecraft.client.renderer.VertexBuffer vb) {
        if (sky2VBO != null) {
            sky2VBO.func_177362_c();
        }
        if (glSkyList2 >= 0) {
            GLAllocation.func_74523_b((int)glSkyList2);
            glSkyList2 = -1;
        }
        if (OpenGlHelper.func_176075_f()) {
            sky2VBO = new VertexBuffer(vertexBufferFormat);
            RenderDefaultSkybox.setupSkyVertices(vb, -16.0f, true);
            vb.func_178977_d();
            vb.func_178965_a();
            sky2VBO.func_181722_a(vb.func_178966_f());
        } else {
            glSkyList2 = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)glSkyList2, (int)4864);
            RenderDefaultSkybox.setupSkyVertices(vb, -16.0f, true);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glEndList();
        }
    }

    private static void setupSky1(net.minecraft.client.renderer.VertexBuffer vb) {
        if (skyVBO != null) {
            skyVBO.func_177362_c();
        }
        if (glSkyList >= 0) {
            GLAllocation.func_74523_b((int)glSkyList);
            glSkyList = -1;
        }
        if (OpenGlHelper.func_176075_f()) {
            skyVBO = new VertexBuffer(vertexBufferFormat);
            RenderDefaultSkybox.setupSkyVertices(vb, 16.0f, false);
            vb.func_178977_d();
            vb.func_178965_a();
            skyVBO.func_181722_a(vb.func_178966_f());
        } else {
            glSkyList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)glSkyList, (int)4864);
            RenderDefaultSkybox.setupSkyVertices(vb, 16.0f, false);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glEndList();
        }
    }

    private static void setupStars(net.minecraft.client.renderer.VertexBuffer vb) {
        if (starVBO != null) {
            starVBO.func_177362_c();
        }
        if (starGLCallList >= 0) {
            GLAllocation.func_74523_b((int)starGLCallList);
            starGLCallList = -1;
        }
        if (OpenGlHelper.func_176075_f()) {
            starVBO = new VertexBuffer(vertexBufferFormat);
            RenderDefaultSkybox.setupStarVertices(vb);
            vb.func_178977_d();
            vb.func_178965_a();
            starVBO.func_181722_a(vb.func_178966_f());
        } else {
            starGLCallList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_179094_E();
            GL11.glNewList((int)starGLCallList, (int)4864);
            RenderDefaultSkybox.setupStarVertices(vb);
            Tessellator.func_178181_a().func_78381_a();
            GL11.glEndList();
            GlStateManager.func_179121_F();
        }
    }

    private static void setupSkyVertices(net.minecraft.client.renderer.VertexBuffer vb, float y, boolean invert) {
        vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (invert) {
                    f1 = k;
                    f = k + 64;
                }
                vb.func_181662_b((double)f, (double)y, (double)l).func_181675_d();
                vb.func_181662_b((double)f1, (double)y, (double)l).func_181675_d();
                vb.func_181662_b((double)f1, (double)y, (double)(l + 64)).func_181675_d();
                vb.func_181662_b((double)f, (double)y, (double)(l + 64)).func_181675_d();
            }
        }
    }

    private static void setupStarVertices(net.minecraft.client.renderer.VertexBuffer vb) {
        Random random = new Random(10842L);
        vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double x = random.nextFloat() * 2.0f - 1.0f;
            double y = random.nextFloat() * 2.0f - 1.0f;
            double z = random.nextFloat() * 2.0f - 1.0f;
            double ovrSize = 0.15f + random.nextFloat() * 0.1f;
            double d4 = x * x + y * y + z * z;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (x *= d4) * 100.0;
            double d6 = (y *= d4) * 100.0;
            double d7 = (z *= d4) * 100.0;
            double d8 = Math.atan2(x, z);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(x * x + z * z), y);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double size = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * ovrSize;
                double d19 = (double)((j + 1 & 2) - 1) * ovrSize;
                double d21 = d18 * d16 - d19 * size;
                double d22 = d19 * d16 + d18 * size;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                vb.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        RenderDefaultSkybox.renderDefaultSkybox(partialTicks);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private static void renderDefaultSkybox(float partialTicks) {
        GlStateManager.func_179090_x();
        Vec3d vec3 = Minecraft.func_71410_x().field_71441_e.func_72833_a(Minecraft.func_71410_x().func_175606_aa(), partialTicks);
        float f = (float)vec3.field_72450_a;
        float f1 = (float)vec3.field_72448_b;
        float f2 = (float)vec3.field_72449_c;
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        Tessellator tessellator = Tessellator.func_178181_a();
        net.minecraft.client.renderer.VertexBuffer vb = tessellator.func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        if (OpenGlHelper.func_176075_f()) {
            skyVBO.func_177359_a();
            GL11.glEnableClientState((int)32884);
            GL11.glVertexPointer((int)3, (int)5126, (int)12, (long)0L);
            skyVBO.func_177358_a(7);
            skyVBO.func_177361_b();
            GL11.glDisableClientState((int)32884);
        } else {
            GlStateManager.func_179148_o((int)glSkyList);
        }
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        float[] afloat = Minecraft.func_71410_x().field_71441_e.field_73011_w.func_76560_a(Minecraft.func_71410_x().field_71441_e.func_72826_c(partialTicks), partialTicks);
        if (afloat != null) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)Minecraft.func_71410_x().field_71441_e.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f6 = afloat[0];
            float f7 = afloat[1];
            float f8 = afloat[2];
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                float f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                float f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
                float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                f6 = f9;
                f7 = f10;
                f8 = f11;
            }
            vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            vb.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f6, f7, f8, afloat[3]).func_181675_d();
            for (int l = 0; l <= 16; ++l) {
                float f21 = (float)l * (float)Math.PI * 2.0f / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f21);
                float f13 = MathHelper.func_76134_b((float)f21);
                vb.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3])).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_179094_E();
        float f16 = 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f16);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(Minecraft.func_71410_x().field_71441_e.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f17 = 30.0f;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(MC_DEF_SUN_PNG);
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(-f17), 100.0, (double)(-f17)).func_187315_a(0.0, 0.0).func_181675_d();
        vb.func_181662_b((double)f17, 100.0, (double)(-f17)).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)f17, 100.0, (double)f17).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(-f17), 100.0, (double)f17).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        f17 = 20.0f;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(MC_DEF_MOON_PHASES_PNG);
        int i = Minecraft.func_71410_x().field_71441_e.func_72853_d();
        int k = i % 4;
        int i1 = i / 4 % 2;
        float f22 = (float)k / 4.0f;
        float f23 = (float)i1 / 2.0f;
        float f24 = (float)(k + 1) / 4.0f;
        float f14 = (float)(i1 + 1) / 2.0f;
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(-f17), -100.0, (double)f17).func_187315_a((double)f24, (double)f14).func_181675_d();
        vb.func_181662_b((double)f17, -100.0, (double)f17).func_187315_a((double)f22, (double)f14).func_181675_d();
        vb.func_181662_b((double)f17, -100.0, (double)(-f17)).func_187315_a((double)f22, (double)f23).func_181675_d();
        vb.func_181662_b((double)(-f17), -100.0, (double)(-f17)).func_187315_a((double)f24, (double)f23).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179090_x();
        float f15 = Minecraft.func_71410_x().field_71441_e.func_72880_h(partialTicks) * f16;
        if (f15 > 0.0f) {
            GlStateManager.func_179131_c((float)f15, (float)f15, (float)f15, (float)f15);
            if (OpenGlHelper.func_176075_f()) {
                starVBO.func_177359_a();
                GL11.glEnableClientState((int)32884);
                GL11.glVertexPointer((int)3, (int)5126, (int)12, (long)0L);
                starVBO.func_177358_a(7);
                starVBO.func_177361_b();
                GL11.glDisableClientState((int)32884);
            } else {
                GlStateManager.func_179148_o((int)starGLCallList);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179127_m();
        GlStateManager.func_179121_F();
        GlStateManager.func_179090_x();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = Minecraft.func_71410_x().field_71439_g.func_174824_e((float)partialTicks).field_72448_b - Minecraft.func_71410_x().field_71441_e.func_72919_O();
        if (d0 < 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            if (OpenGlHelper.func_176075_f()) {
                sky2VBO.func_177359_a();
                GL11.glEnableClientState((int)32884);
                GL11.glVertexPointer((int)3, (int)5126, (int)12, (long)0L);
                sky2VBO.func_177358_a(7);
                sky2VBO.func_177361_b();
                GL11.glDisableClientState((int)32884);
            } else {
                GlStateManager.func_179148_o((int)glSkyList2);
            }
            GlStateManager.func_179121_F();
            float f19 = -((float)(d0 + 65.0));
            vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vb.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vb.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.func_76561_g()) {
            GlStateManager.func_179124_c((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        } else {
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GlStateManager.func_179148_o((int)glSkyList2);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    static {
        starGLCallList = -1;
        glSkyList = -1;
        glSkyList2 = -1;
        MC_DEF_SUN_PNG = new ResourceLocation("textures/environment/sun.png");
        MC_DEF_MOON_PHASES_PNG = new ResourceLocation("textures/environment/moon_phases.png");
    }
}

