/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.math.BlockPos;

public class ClientScreenshotCache {
    private static ResourceLocation nullEntry = new ResourceLocation("astralsorcery", "NULL-NONACCESS");
    private static String addrContext = null;
    private static Map<Integer, List<Tuple<BlockPos, ResourceLocation>>> clientScreenshots = new HashMap<Integer, List<Tuple<BlockPos, ResourceLocation>>>();

    @Nullable
    public static ResourceLocation tryQueryTextureFor(int dim, BlockPos pos) {
        List<Tuple<BlockPos, ResourceLocation>> positions = clientScreenshots.get(dim);
        if (positions == null) {
            positions = new LinkedList<Tuple<BlockPos, ResourceLocation>>();
            clientScreenshots.put(dim, positions);
        }
        for (Tuple<BlockPos, ResourceLocation> t : positions) {
            if (!((BlockPos)t.key).equals((Object)pos)) continue;
            if (((ResourceLocation)t.value).equals((Object)nullEntry)) {
                return null;
            }
            return (ResourceLocation)t.value;
        }
        positions.add(new Tuple<BlockPos, ResourceLocation>(pos, nullEntry));
        return null;
    }

    public static void takeViewScreenshotFor(int dim, BlockPos pos) {
        AstralSorcery.proxy.scheduleClientside(() -> {
            try {
                File dir = ClientScreenshotCache.getDirectoryForCurrentContext();
                File worldDir = new File(dir, String.valueOf(dim));
                if (!worldDir.exists()) {
                    worldDir.mkdirs();
                }
                File store = new File(worldDir, pos.func_177958_n() + ";" + pos.func_177956_o() + ";" + pos.func_177952_p() + ".png");
                boolean wasUIHidden = Minecraft.func_71410_x().field_71474_y.field_74319_N;
                EffectHandler.getInstance().renderGateway = false;
                Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
                AstralSorcery.proxy.scheduleClientside(() -> {
                    try {
                        BufferedImage bufferedimage = ScreenShotHelper.func_186719_a((int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (Framebuffer)Minecraft.func_71410_x().func_147110_a());
                        ImageIO.write((RenderedImage)bufferedimage, "png", store);
                        Minecraft.func_71410_x().field_71474_y.field_74319_N = wasUIHidden;
                        EffectHandler.getInstance().renderGateway = true;
                        ResourceLocation address = ClientScreenshotCache.addScreenshot(dim, pos, store);
                        Tuple<BlockPos, ResourceLocation> addr = new Tuple<BlockPos, ResourceLocation>(pos, address);
                        if (!clientScreenshots.containsKey(dim)) {
                            clientScreenshots.put(dim, new LinkedList());
                        }
                        List<Tuple<BlockPos, ResourceLocation>> positions = clientScreenshots.get(dim);
                        positions.removeIf(entry -> ((BlockPos)entry.key).equals((Object)pos));
                        positions.add(addr);
                    }
                    catch (Exception exc) {
                        AstralSorcery.log.info("Couldn't save screenshot for position: dimid=" + dim + ", pos=" + pos.toString());
                        exc.printStackTrace();
                    }
                });
            }
            catch (Exception exc) {
                AstralSorcery.log.info("Couldn't save screenshot for position: dimid=" + dim + ", pos=" + pos.toString());
                exc.printStackTrace();
            }
        });
    }

    public static void cleanUp() {
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        for (List<Tuple<BlockPos, ResourceLocation>> rlList : clientScreenshots.values()) {
            for (Tuple<BlockPos, ResourceLocation> rl : rlList) {
                tm.func_147645_c((ResourceLocation)rl.value);
            }
        }
        addrContext = null;
        clientScreenshots.clear();
    }

    public static void loadAndInitScreenshotsFor(String addr) {
        ClientScreenshotCache.cleanUp();
        addrContext = addr;
        try {
            ClientScreenshotCache.loadScreenshots(ClientScreenshotCache.getDirectoryForCurrentContext());
            AstralSorcery.log.info("Using gateway screenshots for folder '" + addrContext + "'");
        }
        catch (Exception exc) {
            AstralSorcery.log.info("Couldn't load screenshots from local cache for address " + addrContext);
            exc.printStackTrace();
        }
    }

    private static void loadScreenshots(File directory) throws Exception {
        if (directory == null) {
            return;
        }
        for (File dimDir : directory.listFiles()) {
            int dimId;
            if (!dimDir.isDirectory()) continue;
            String fileName = dimDir.getName();
            try {
                dimId = Integer.parseInt(fileName);
            }
            catch (NumberFormatException exc) {
                AstralSorcery.log.info("Couldn't load screenshots from folder " + fileName + " as its not a dimensionID. Skipping.");
                continue;
            }
            LinkedList<Tuple<BlockPos, ResourceLocation>> textures = new LinkedList<Tuple<BlockPos, ResourceLocation>>();
            for (File imageF : dimDir.listFiles()) {
                int z;
                int y;
                int x;
                String[] spl;
                String posName;
                if (imageF.isDirectory() || !(posName = imageF.getName()).endsWith(".png") || (spl = (posName = posName.substring(0, posName.length() - 4)).split(";")).length != 3) continue;
                try {
                    x = Integer.parseInt(spl[0]);
                    y = Integer.parseInt(spl[1]);
                    z = Integer.parseInt(spl[2]);
                }
                catch (NumberFormatException exc) {
                    continue;
                }
                BlockPos pos = new BlockPos(x, y, z);
                ResourceLocation textureAddress = ClientScreenshotCache.addScreenshot(dimId, pos, imageF);
                Tuple<BlockPos, ResourceLocation> adress = new Tuple<BlockPos, ResourceLocation>(pos, textureAddress);
                textures.add(adress);
            }
            clientScreenshots.put(dimId, textures);
        }
    }

    private static ResourceLocation addScreenshot(int dimId, BlockPos pos, File imageFile) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ResourceLocation textureAddress = new ResourceLocation("astralsorcery", dimId + ";;" + x + ";" + y + ";" + z);
        FileBasedTexture fbt = new FileBasedTexture(imageFile);
        Minecraft.func_71410_x().func_110434_K().func_110579_a(textureAddress, (ITextureObject)fbt);
        return textureAddress;
    }

    @Nullable
    private static File getDirectoryForCurrentContext() {
        if (addrContext == null) {
            return null;
        }
        File f = new File(System.getProperty("user.dir"), "astralsorcery");
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(f = new File(f, "gatewayScreenshots")).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(f, addrContext)).exists()) {
            f.mkdirs();
        }
        return f;
    }

    private static class FileBasedTexture
    extends AbstractTexture {
        private final File f;

        public FileBasedTexture(File f) {
            this.f = f;
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            this.func_147631_c();
            BufferedImage image = TextureUtil.func_177053_a((InputStream)new FileInputStream(this.f));
            int pxWidth = image.getWidth();
            int pxHeight = image.getHeight();
            int nX = pxWidth / 5;
            int nH = pxHeight / 5;
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)image.getSubimage(nX, nH, pxWidth - nX, pxHeight - nH), (boolean)true, (boolean)false);
        }
    }
}

