/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.sky.RenderAstralSkybox;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.base.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class UIGateway {
    private List<GatewayEntry> gatewayEntries = new LinkedList<GatewayEntry>();
    private final Vector3 origin;
    private final double radius;

    private UIGateway(Vector3 pos, double radius) {
        this.origin = pos;
        this.radius = radius;
    }

    public Vector3 getPos() {
        return this.origin;
    }

    public double getRadius() {
        return this.radius;
    }

    public static UIGateway initialize(World world, Vector3 source, double sphereRadius) {
        UIGateway ui = new UIGateway(source, sphereRadius);
        CelestialGatewaySystem system = CelestialGatewaySystem.instance;
        int dimid = world.field_73011_w.getDimension();
        List<BlockPos> sameDimensionPositions = system.getGatewaysForWorld(world, Side.CLIENT);
        UIGateway.gatherStars(ui, world.field_73011_w.getDimension(), sameDimensionPositions, true, sphereRadius);
        for (Map.Entry<Integer, List<BlockPos>> entries : system.getGatewayCache(Side.CLIENT).entrySet()) {
            if (entries.getKey() == dimid) continue;
            List<BlockPos> otherPositions = entries.getValue();
            UIGateway.gatherStars(ui, entries.getKey(), otherPositions, false, sphereRadius);
        }
        return ui;
    }

    @Nullable
    public GatewayEntry findMatchingEntry(float yaw, float pitch) {
        float matchAccurancy = 4.0f;
        for (GatewayEntry entry : this.gatewayEntries) {
            if (!(Math.abs(entry.pitch - pitch) < matchAccurancy) || !(Math.abs(entry.yaw - yaw) <= matchAccurancy) && !(Math.abs(entry.yaw - yaw - 360.0f) <= matchAccurancy)) continue;
            return entry;
        }
        return null;
    }

    private static void gatherStars(UIGateway gateway, int dimId, List<BlockPos> otherPositions, boolean sameWorld, double sphereRadius) {
        Vector3 gatePosition = gateway.getPos();
        for (BlockPos other : otherPositions) {
            Vector3 otherPos = new Vector3(other);
            if (sameWorld && otherPos.distance(gatePosition) < 16.0) continue;
            Vector3 direction = otherPos.subtract(gatePosition).normalize().multiply(sphereRadius);
            GatewayEntry potentialEntry = new GatewayEntry(other, dimId, direction);
            if (sameWorld) {
                boolean mayAdd = true;
                for (GatewayEntry entry : gateway.gatewayEntries) {
                    if (!(Math.abs(entry.pitch - potentialEntry.pitch) < 25.0f) || !(Math.abs(entry.yaw - potentialEntry.yaw) <= 25.0f) && !(Math.abs(entry.yaw - potentialEntry.yaw - 360.0f) <= 25.0f)) continue;
                    mayAdd = false;
                }
                if (!mayAdd) continue;
                gateway.gatewayEntries.add(potentialEntry);
                continue;
            }
            long seed = -6395079716991528811L;
            seed |= (long)other.func_177958_n() << 48;
            seed |= (long)other.func_177956_o() << 24;
            Random rand = new Random(seed |= (long)other.func_177952_p());
            direction = Vector3.positiveYRandom(rand).normalize().multiply(sphereRadius);
            potentialEntry = new GatewayEntry(other, dimId, direction);
            boolean foundSpace = false;
            for (int tries = 30; !foundSpace && tries > 0; --tries) {
                boolean mayAdd = true;
                for (GatewayEntry entry : gateway.gatewayEntries) {
                    if (!(Math.abs(entry.pitch - potentialEntry.pitch) < 10.0f) || !(Math.abs(entry.yaw - potentialEntry.yaw) <= 10.0f) && !(Math.abs(entry.yaw - potentialEntry.yaw - 360.0f) <= 10.0f)) continue;
                    mayAdd = false;
                }
                if (mayAdd) {
                    foundSpace = true;
                    continue;
                }
                direction = Vector3.positiveYRandom(rand).normalize().multiply(sphereRadius);
                potentialEntry = new GatewayEntry(other, dimId, direction);
            }
            if (!foundSpace) continue;
            gateway.gatewayEntries.add(potentialEntry);
        }
    }

    public void renderIntoWorld(float pticks) {
        float a;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        double dst = new Vector3(this.origin).distance(new Vector3((Entity)Minecraft.func_71410_x().field_71439_g));
        if (dst > 3.0) {
            return;
        }
        float alpha = 1.0f - (float)(dst / 2.0);
        alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
        Color c = new Color(15777024);
        float red = (float)c.getRed() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        long seed = -6376616654017193693L;
        seed |= (long)this.origin.getBlockX() << 48;
        seed |= (long)this.origin.getBlockY() << 24;
        Random rand = new Random(seed |= (long)this.origin.getBlockZ());
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        GL11.glDisable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderAstralSkybox.TEX_STAR_1.bind();
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (int i = 0; i < 300; ++i) {
            Vector3 dir = Vector3.random(rand).normalize().multiply(this.radius);
            a = RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), pticks, rand.nextInt(7) + 6);
            RenderingUtils.renderFacingFullQuadVB(vb, this.origin.getX() + dir.getX(), this.origin.getY() + dir.getY(), this.origin.getZ() + dir.getZ(), pticks, 0.07f, 0.0f, 1.0f, 1.0f, 1.0f, a *= alpha);
        }
        for (GatewayEntry entry : this.gatewayEntries) {
            a = RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), pticks, rand.nextInt(7) + 6);
            a = 0.4f + 0.6f * a;
            RenderingUtils.renderFacingFullQuadVB(vb, this.origin.getX() + entry.relativePos.getX(), this.origin.getY() + entry.relativePos.getY(), this.origin.getZ() + entry.relativePos.getZ(), pticks, 0.16f, 0.0f, red, green, blue, a *= alpha);
        }
        RenderingUtils.sortVertexData(vb);
        tes.func_78381_a();
        TextureHelper.refreshTextureBindState();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public static class GatewayEntry {
        public final BlockPos originalBlockPos;
        public final int originalDimId;
        public final Vector3 relativePos;
        private final float yaw;
        private final float pitch;

        private GatewayEntry(BlockPos originalBlockPos, int originalDimId, Vector3 relativePos) {
            this.originalBlockPos = originalBlockPos;
            this.originalDimId = originalDimId;
            this.relativePos = relativePos.clone();
            if (this.relativePos.getY() < 0.0) {
                this.relativePos.setY(0);
            }
            Vector3 angles = relativePos.copyToPolar();
            this.yaw = (float)(180.0 - angles.getZ());
            this.pitch = Math.min(0.0f, (float)(-90.0 + angles.getY()));
        }
    }
}

