/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.item;

import hellfirepvp.astralsorcery.client.util.item.IItemRenderer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemRenderRegistry {
    private static Map<ResourceLocation, IItemRenderer> registeredItems = new HashMap<ResourceLocation, IItemRenderer>();
    private static Map<ResourceLocation, ItemCameraTransforms> registeredCameraTransforms = new HashMap<ResourceLocation, ItemCameraTransforms>();

    public static boolean isRegistered(ResourceLocation location) {
        return location != null && registeredItems.containsKey(location);
    }

    public static boolean shouldHandleItemRendering(ItemStack stack) {
        if (stack.func_77973_b() == null) {
            return false;
        }
        ResourceLocation entry = ItemRenderRegistry.getWrappedLocation(stack.func_77973_b().getRegistryName());
        return entry != null && ItemRenderRegistry.isRegistered(entry);
    }

    public static void renderItemStack(ItemStack stack) {
        ResourceLocation loc = stack.func_77973_b().getRegistryName();
        IItemRenderer renderer = registeredItems.get(ItemRenderRegistry.getWrappedLocation(loc));
        renderer.render(stack);
    }

    public static void registerCameraTransforms(Item item, ItemCameraTransforms additionalTransforms) {
        registeredCameraTransforms.put(item.getRegistryName(), additionalTransforms);
    }

    public static ItemCameraTransforms getAdditionalRenderTransforms(ResourceLocation itemRegistryLocation) {
        return registeredCameraTransforms.get(itemRegistryLocation);
    }

    public static void register(Item item, IItemRenderer renderer) {
        ResourceLocation loc = item.getRegistryName();
        registeredItems.put(ItemRenderRegistry.getWrappedLocation(loc), renderer);
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(item, (ItemMeshDefinition)new DummyMeshDefinition(loc));
    }

    private static ResourceLocation getWrappedLocation(ResourceLocation regEntry) {
        return new ResourceLocation(regEntry.func_110624_b(), "models/item/" + regEntry.func_110623_a());
    }

    private static class DummyMeshDefinition
    implements ItemMeshDefinition {
        private ModelResourceLocation fallback;

        public DummyMeshDefinition(ResourceLocation loc) {
            this.fallback = new ModelResourceLocation(loc, "inventory");
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.fallback;
        }
    }
}

