/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common;

import com.mojang.authlib.GameProfile;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonScheduler;
import hellfirepvp.astralsorcery.common.auxiliary.link.LinkHandler;
import hellfirepvp.astralsorcery.common.auxiliary.tick.TickManager;
import hellfirepvp.astralsorcery.common.base.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.base.HerdableAnimal;
import hellfirepvp.astralsorcery.common.base.LightOreTransmutations;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.base.TileAccelerationBlacklist;
import hellfirepvp.astralsorcery.common.base.TreeTypes;
import hellfirepvp.astralsorcery.common.base.WellLiquefaction;
import hellfirepvp.astralsorcery.common.constellation.charge.PlayerChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerkLevelManager;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerks;
import hellfirepvp.astralsorcery.common.constellation.perk.PlayerPerkHandler;
import hellfirepvp.astralsorcery.common.container.ContainerAltarAttunement;
import hellfirepvp.astralsorcery.common.container.ContainerAltarConstellation;
import hellfirepvp.astralsorcery.common.container.ContainerAltarDiscovery;
import hellfirepvp.astralsorcery.common.container.ContainerAltarTrait;
import hellfirepvp.astralsorcery.common.container.ContainerJournal;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerAchievements;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerMisc;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerNetwork;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerServer;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationBloodMagic;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationCrafttweaker;
import hellfirepvp.astralsorcery.common.item.ItemJournal;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktLightningEffect;
import hellfirepvp.astralsorcery.common.registry.RegistryAchievements;
import hellfirepvp.astralsorcery.common.registry.RegistryBlocks;
import hellfirepvp.astralsorcery.common.registry.RegistryConstellations;
import hellfirepvp.astralsorcery.common.registry.RegistryEnchantments;
import hellfirepvp.astralsorcery.common.registry.RegistryEntities;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.registry.RegistryPerks;
import hellfirepvp.astralsorcery.common.registry.RegistryPotions;
import hellfirepvp.astralsorcery.common.registry.RegistryRecipes;
import hellfirepvp.astralsorcery.common.registry.RegistryResearch;
import hellfirepvp.astralsorcery.common.registry.RegistrySounds;
import hellfirepvp.astralsorcery.common.registry.RegistryStructures;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightNetworkRegistry;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionChunkTracker;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeacon;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.LootTableUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import hellfirepvp.astralsorcery.common.util.TreeCaptureHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.world.AstralWorldGenerator;
import hellfirepvp.astralsorcery.common.world.retrogen.ChunkVersionController;
import hellfirepvp.astralsorcery.common.world.retrogen.RetroGenController;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class CommonProxy
implements IGuiHandler {
    public static DamageSource dmgSourceBleed = new DamageSource("as.bleed").func_76348_h();
    public static DamageSource dmgSourceStellar = new DamageSource("as.stellar").func_76348_h().func_82726_p();
    private static UUID fakePlayerUUID = UUID.fromString("BD4F59E2-4E26-4388-B903-B533D482C205");
    public static AstralWorldGenerator worldGenerator = new AstralWorldGenerator();
    private CommonScheduler commonScheduler = new CommonScheduler();

    public void preLoadConfigEntries() {
        worldGenerator.pushConfigEntries();
        ConstellationEffectRegistry.addDynamicConfigEntries();
        ConstellationPerks.addDynamicConfigEntries();
        Config.addDynamicEntry(TileTreeBeacon.ConfigEntryTreeBeacon.instance);
        Config.addDynamicEntry(ConstellationPerkLevelManager.getLevelConfigurations());
    }

    public void preInit() {
        RegistryItems.setupDefaults();
        RegistryEnchantments.init();
        RegistryConstellations.init();
        PacketChannel.init();
        RegistryBlocks.init();
        RegistryItems.init();
        RegistryEntities.init();
        RegistryStructures.init();
        RegistryPotions.init();
        SourceClassRegistry.setupRegistry();
        TransmissionClassRegistry.setupRegistry();
        StarlightNetworkRegistry.setupRegistry();
        RegistryBlocks.initRenderRegistry();
        RegistryRecipes.init();
        RegistryResearch.init();
        LootTableUtil.initLootTable();
        ConstellationEffectRegistry.init();
        this.registerOreDictEntries();
        RegistryAchievements.init();
        RegistryPerks.init();
        this.registerCapabilities();
    }

    private void registerCapabilities() {
    }

    private void registerOreDictEntries() {
        OreDictionary.registerOre((String)OreDictAlias.BLOCK_MARBLE, (ItemStack)new ItemStack((Block)BlocksAS.blockMarble, 1, 0));
        OreDictionary.registerOre((String)"blockMarble", (ItemStack)new ItemStack((Block)BlocksAS.blockMarble, 1, 0));
    }

    public void init() {
        if (Mods.MINETWEAKER.isPresent()) {
            AstralSorcery.log.info("Minetweaker found! Adding recipe handlers...");
            ModIntegrationCrafttweaker.instance.load();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)AstralSorcery.instance, (IGuiHandler)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)TreeCaptureHelper.eventInstance);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerNetwork());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerServer());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerAchievements());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerMisc());
        MinecraftForge.EVENT_BUS.register((Object)TransmissionChunkTracker.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)TickManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)StarlightTransmissionHandler.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)new LootTableUtil());
        MinecraftForge.EVENT_BUS.register((Object)BlockDropCaptureAssist.instance);
        MinecraftForge.EVENT_BUS.register((Object)ChunkVersionController.instance);
        MinecraftForge.EVENT_BUS.register((Object)CelestialGatewaySystem.instance);
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator.setupAttributes(), (int)50);
        if (Config.enableRetroGen) {
            MinecraftForge.EVENT_BUS.register((Object)new RetroGenController());
        }
        RegistrySounds.init();
        TickManager manager = TickManager.getInstance();
        this.registerTickHandlers(manager);
        SyncDataHolder.initialize();
        TileAccelerationBlacklist.init();
        OreTypes.init();
        LightOreTransmutations.init();
        HerdableAnimal.init();
        WellLiquefaction.init();
        TreeTypes.init();
    }

    protected void registerTickHandlers(TickManager manager) {
        manager.register(ConstellationSkyHandler.getInstance());
        manager.register(StarlightTransmissionHandler.getInstance());
        manager.register(StarlightUpdateHandler.getInstance());
        manager.register(WorldCacheManager.getInstance());
        manager.register(new LinkHandler());
        manager.register(SyncDataHolder.getTickInstance());
        manager.register(new PlayerPerkHandler());
        manager.register(this.commonScheduler);
        manager.register(PlayerChargeHandler.instance);
        manager.register(EventHandlerServer.spawnDenyRegions);
        manager.register(EventHandlerServer.perkCooldowns);
        manager.register(EventHandlerServer.invulnerabilityCooldown);
    }

    public void postInit() {
        ModIntegrationBloodMagic.sendIMC();
        AstralSorcery.log.info("[AstralSorcery] Post compile recipes");
        CraftingAccessManager.compile();
    }

    public void clientFinishedLoading() {
        ItemHandle.ignoreGatingRequirement = false;
    }

    public FakePlayer getASFakePlayerServer(WorldServer world) {
        return FakePlayerFactory.get((WorldServer)world, (GameProfile)new GameProfile(UUID.randomUUID(), "AS-FakePlayer"));
    }

    public void registerVariantName(Item item, String name) {
    }

    public void registerBlockRender(Block block, int metadata, String name) {
    }

    public void registerItemRender(Item item, int metadata, String name) {
    }

    public <T extends Item> void registerItemRender(T item, int metadata, String name, boolean variant) {
    }

    public void registerFromSubItems(Item item, String name) {
    }

    public void scheduleClientside(Runnable r, int tickDelay) {
    }

    public void scheduleClientside(Runnable r) {
        this.scheduleClientside(r, 0);
    }

    public void scheduleDelayed(Runnable r, int tickDelay) {
        this.commonScheduler.addRunnable(r, tickDelay);
    }

    public void scheduleDelayed(Runnable r) {
        this.scheduleDelayed(r, 0);
    }

    public void fireLightning(World world, Vector3 from, Vector3 to) {
        this.fireLightning(world, from, to, null);
    }

    public void fireLightning(World world, Vector3 from, Vector3 to, Color overlay) {
        PktLightningEffect effect = new PktLightningEffect(from, to);
        if (overlay != null) {
            effect.setColorOverlay(overlay);
        }
        PacketChannel.CHANNEL.sendToAllAround((IMessage)effect, PacketChannel.pointFromPos(world, from.toBlockPos(), 40.0));
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id < 0 || id >= EnumGuiId.values().length) {
            return null;
        }
        EnumGuiId guiType = EnumGuiId.values()[id];
        TileEntity t = null;
        if (guiType.getTileClass() != null && (t = MiscUtils.getTileAt((IBlockAccess)world, new BlockPos(x, y, z), guiType.getTileClass(), true)) == null) {
            return null;
        }
        switch (guiType) {
            case ALTAR_DISCOVERY: {
                return new ContainerAltarDiscovery(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_ATTUNEMENT: {
                return new ContainerAltarAttunement(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_CONSTELLATION: {
                return new ContainerAltarConstellation(player.field_71071_by, (TileAltar)t);
            }
            case ALTAR_TRAIT: {
                return new ContainerAltarTrait(player.field_71071_by, (TileAltar)t);
            }
            case JOURNAL_STORAGE: {
                ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
                if (held == null || held.func_77973_b() == null || !(held.func_77973_b() instanceof ItemJournal)) break;
                return new ContainerJournal(player.field_71071_by, held, player.field_71071_by.field_70461_c);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void openGui(EnumGuiId guiId, EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)AstralSorcery.instance, guiId.ordinal(), world, x, y, z);
    }

    public static enum EnumGuiId {
        TELESCOPE(TileTelescope.class),
        HAND_TELESCOPE,
        CONSTELLATION_PAPER,
        ALTAR_DISCOVERY(TileAltar.class),
        ALTAR_ATTUNEMENT(TileAltar.class),
        ALTAR_CONSTELLATION(TileAltar.class),
        ALTAR_TRAIT(TileAltar.class),
        MAP_DRAWING(TileMapDrawingTable.class),
        JOURNAL,
        JOURNAL_STORAGE;

        private final Class<? extends TileEntity> tileClass;

        private EnumGuiId() {
            this(null);
        }

        private EnumGuiId(Class<? extends TileEntity> tileClass) {
            this.tileClass = tileClass;
        }

        public Class<? extends TileEntity> getTileClass() {
            return this.tileClass;
        }
    }
}

