/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.common.CommonProxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;

public interface HerdableAnimal<T extends EntityLivingBase> {
    public static final Map<Class<?>, HerdableAnimal> registryHerdable = new HashMap();

    public static <T extends EntityLivingBase> HerdableAnimal<T> getHerdable(T entity) {
        return registryHerdable.get(entity.getClass());
    }

    public static void init() {
        HerdableAnimal.register(new Cow());
        HerdableAnimal.register(new Chicken());
        HerdableAnimal.register(new Sheep());
        HerdableAnimal.register(new Pig());
        HerdableAnimal.register(new Horse());
        HerdableAnimal.register(new Rabbit());
        HerdableAnimal.register(new Squid());
        HerdableAnimal.register(new Mooshroom());
        HerdableAnimal.register(new PolarBear());
    }

    public static void register(HerdableAnimal herd) {
        registryHerdable.put(herd.getEntityClass(), herd);
    }

    public Class<T> getEntityClass();

    @Nonnull
    public List<ItemStack> getHerdingDropsTick(T var1, World var2, Random var3, float var4);

    public static class Pig
    implements HerdableAnimal<EntityPig> {
        @Override
        public Class<EntityPig> getEntityClass() {
            return EntityPig.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntityPig entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            return world.func_184146_ak().func_186521_a(LootTableList.field_186395_C).func_186462_a(rand, builder.func_186471_a());
        }
    }

    public static class Sheep
    implements HerdableAnimal<EntitySheep> {
        @Override
        public Class<EntitySheep> getEntityClass() {
            return EntitySheep.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntitySheep entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            List drops = world.func_184146_ak().func_186521_a(LootTableList.field_186403_K).func_186462_a(rand, builder.func_186471_a());
            if ((double)rand.nextFloat() <= 0.01) {
                entity.func_70893_e(true);
            }
            if (!entity.func_70892_o() && (double)rand.nextFloat() <= 0.05) {
                drops.add(new ItemStack(Blocks.field_150325_L, rand.nextInt(2) + 1));
            }
            return drops;
        }
    }

    public static class Chicken
    implements HerdableAnimal<EntityChicken> {
        @Override
        public Class<EntityChicken> getEntityClass() {
            return EntityChicken.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntityChicken entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            List drops = world.func_184146_ak().func_186521_a(LootTableList.field_186394_B).func_186462_a(rand, builder.func_186471_a());
            if ((double)rand.nextFloat() <= 0.2) {
                drops.add(new ItemStack(Items.field_151110_aK));
            }
            return drops;
        }
    }

    public static class Cow
    implements HerdableAnimal<EntityCow> {
        @Override
        public Class<EntityCow> getEntityClass() {
            return EntityCow.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntityCow entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            List drops = world.func_184146_ak().func_186521_a(LootTableList.field_186399_G).func_186462_a(rand, builder.func_186471_a());
            if ((double)rand.nextFloat() <= 0.15 * (double)Math.max(0.0f, herdingLuck)) {
                drops.add(new ItemStack(Items.field_151117_aB));
            }
            return drops;
        }
    }

    public static class Squid
    implements HerdableAnimal<EntitySquid> {
        @Override
        public Class<EntitySquid> getEntityClass() {
            return EntitySquid.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntitySquid entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            return world.func_184146_ak().func_186521_a(LootTableList.field_186381_af).func_186462_a(rand, builder.func_186471_a());
        }
    }

    public static class Horse
    implements HerdableAnimal<EntityHorse> {
        @Override
        public Class<EntityHorse> getEntityClass() {
            return EntityHorse.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntityHorse entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            return world.func_184146_ak().func_186521_a(LootTableList.field_186396_D).func_186462_a(rand, builder.func_186471_a());
        }
    }

    public static class Rabbit
    implements HerdableAnimal<EntityRabbit> {
        @Override
        public Class<EntityRabbit> getEntityClass() {
            return EntityRabbit.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntityRabbit entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            return world.func_184146_ak().func_186521_a(LootTableList.field_186393_A).func_186462_a(rand, builder.func_186471_a());
        }
    }

    public static class Mooshroom
    implements HerdableAnimal<EntityMooshroom> {
        @Override
        public Class<EntityMooshroom> getEntityClass() {
            return EntityMooshroom.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntityMooshroom entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            List drops = world.func_184146_ak().func_186521_a(LootTableList.field_186400_H).func_186462_a(rand, builder.func_186471_a());
            if ((double)rand.nextFloat() <= 0.05 * (double)Math.max(0.0f, herdingLuck)) {
                drops.add(new ItemStack(Items.field_151009_A));
            }
            return drops;
        }
    }

    public static class PolarBear
    implements HerdableAnimal<EntityPolarBear> {
        @Override
        public Class<EntityPolarBear> getEntityClass() {
            return EntityPolarBear.class;
        }

        @Override
        @Nonnull
        public List<ItemStack> getHerdingDropsTick(EntityPolarBear entity, World world, Random rand, float herdingLuck) {
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            builder.func_186473_a(CommonProxy.dmgSourceStellar).func_186472_a((Entity)entity).func_186469_a(herdingLuck);
            return world.func_184146_ak().func_186521_a(LootTableList.field_189969_E).func_186462_a(rand, builder.func_186471_a());
        }
    }
}

