/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.TileAttunementRelay;
import hellfirepvp.astralsorcery.common.tile.base.TileInventoryBase;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import hellfirepvp.astralsorcery.common.util.struct.BlockDiscoverer;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockAttunementRelay
extends BlockContainer {
    private static final AxisAlignedBB box = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125);

    public BlockAttunementRelay() {
        super(Material.field_151592_s, MapColor.field_151677_p);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149752_b(1.0f);
        this.func_149715_a(0.8f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAttunementRelay();
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAttunementRelay();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            TileEntity inv = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileEntity.class, true);
            if (inv != null) {
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    IItemHandler handle = (IItemHandler)inv.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
                    if (handle == null) continue;
                    ItemUtils.dropInventory(handle, worldIn, pos);
                    break;
                }
            }
            BlockAltar.startSearchForRelayUpdate(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        BlockAttunementRelay.startSearchRelayLinkThreadAt(worldIn, pos, true);
    }

    public static void startSearchRelayLinkThreadAt(World world, BlockPos pos, boolean recUpdate) {
        Thread searchThread = new Thread(() -> {
            BlockPos closestAltar = null;
            double dstSqOtherRelay = Double.MAX_VALUE;
            BlockArray relaysAndAltars = BlockDiscoverer.searchForBlocksAround(world, pos, 16, (world1, pos1, state1) -> state1.func_177230_c().equals(BlocksAS.blockAltar) || state1.func_177230_c().equals((Object)BlocksAS.attunementRelay));
            relaysAndAltars.getPattern().remove(pos);
            for (Map.Entry<BlockPos, BlockArray.BlockInformation> entry : relaysAndAltars.getPattern().entrySet()) {
                if (entry.getValue().type.equals(BlocksAS.blockAltar)) {
                    if (closestAltar != null && !(pos.func_177951_i((Vec3i)entry.getKey()) < pos.func_177951_i((Vec3i)closestAltar))) continue;
                    closestAltar = entry.getKey();
                    continue;
                }
                double dstSqOther = entry.getKey().func_177951_i((Vec3i)pos);
                if (!(dstSqOther < dstSqOtherRelay)) continue;
                dstSqOtherRelay = dstSqOther;
            }
            BlockPos finalClosestAltar = closestAltar;
            double finalDstSqOtherRelay = dstSqOtherRelay;
            AstralSorcery.proxy.scheduleDelayed(() -> {
                TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)world, pos, TileAttunementRelay.class, true);
                if (tar != null) {
                    tar.updatePositionData(finalClosestAltar, finalDstSqOtherRelay);
                }
                if (recUpdate) {
                    BlockAltar.startSearchForRelayUpdate(world, pos);
                }
            });
        });
        searchThread.setName("AttRelay PositionFinder at " + pos.toString());
        searchThread.start();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (held != null) {
                TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileAttunementRelay.class, true);
                if (tar != null) {
                    TileInventoryBase.ItemHandlerTile mod = tar.getInventoryHandler();
                    if (mod.getStackInSlot(0) != null) {
                        ItemStack stack = mod.getStackInSlot(0);
                        ItemUtils.dropItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, stack).func_174868_q();
                        mod.setStackInSlot(0, null);
                        tar.markForUpdate();
                    }
                    if (!worldIn.func_175623_d(pos.func_177984_a())) {
                        return false;
                    }
                    mod.setStackInSlot(0, ItemUtils.copyStackWithSize(held, 1));
                    worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    if (!playerIn.func_184812_l_()) {
                        --held.field_77994_a;
                    }
                    if (held.field_77994_a <= 0) {
                        playerIn.func_184611_a(hand, null);
                    }
                    tar.markForUpdate();
                }
            } else {
                TileInventoryBase.ItemHandlerTile mod;
                TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileAttunementRelay.class, true);
                if (tar != null && (mod = tar.getInventoryHandler()).getStackInSlot(0) != null) {
                    ItemStack stack = mod.getStackInSlot(0);
                    ItemUtils.dropItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, stack).func_174868_q();
                    mod.setStackInSlot(0, null);
                    tar.markForUpdate();
                }
            }
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return box;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

