/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.block.network.IBlockStarlightRecipient;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemRockCrystalBase;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.TileCelestialCrystals;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCelestialCrystals
extends BlockContainer
implements IBlockStarlightRecipient {
    private static final Random rand = new Random();
    public static AxisAlignedBB bbStage0 = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.3, 0.9);
    public static AxisAlignedBB bbStage1 = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.4, 0.9);
    public static AxisAlignedBB bbStage2 = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.5, 0.9);
    public static AxisAlignedBB bbStage3 = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.6, 0.9);
    public static AxisAlignedBB bbStage4 = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.7, 0.9);
    public static PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)4);

    public BlockCelestialCrystals() {
        super(Material.field_151576_e, MapColor.field_151677_p);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149752_b(30.0f);
        this.func_149715_a(0.4f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_176214_u() {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Integer)state.func_177229_b((IProperty)STAGE)) {
            case 0: {
                return bbStage0;
            }
            case 1: {
                return bbStage1;
            }
            case 2: {
                return bbStage2;
            }
            case 3: {
                return bbStage3;
            }
            case 4: {
                return bbStage4;
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 5; ++i) {
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        BlockPos down;
        boolean replaceable = super.func_176196_c(worldIn, pos);
        if (replaceable && !worldIn.isSideSolid(down = pos.func_177977_b(), EnumFacing.UP)) {
            replaceable = false;
        }
        return replaceable;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return super.getPickBlock(world.func_180495_p(pos), target, world, pos, player);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        LinkedList drops = Lists.newLinkedList();
        drops.add(ItemCraftingComponent.MetaType.STARDUST.asStack());
        int stage = (Integer)state.func_177229_b((IProperty)STAGE);
        switch (stage) {
            case 4: {
                if (world == null || !(world instanceof World) || !this.checkSafety((World)world, pos)) break;
                if (fortune > 0 || rand.nextInt(2) == 0) {
                    drops.add(ItemCraftingComponent.MetaType.STARDUST.asStack());
                }
                drops.add(ItemRockCrystalBase.createRandomCelestialCrystal());
                IBlockState down = world.func_180495_p(pos.func_177977_b());
                if (!(down.func_177230_c() instanceof BlockCustomOre) || !((BlockCustomOre.OreType)((Object)down.func_177229_b(BlockCustomOre.ORE_TYPE))).equals((Object)BlockCustomOre.OreType.STARMETAL) || rand.nextInt(3) != 0) break;
                drops.add(ItemRockCrystalBase.createRandomCelestialCrystal());
            }
        }
        return drops;
    }

    private boolean checkSafety(World world, BlockPos pos) {
        EntityPlayer player = world.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
        return player != null && player.func_174818_b(pos) < 100.0;
    }

    @Override
    public void receiveStarlight(World world, Random rand, BlockPos pos, IWeakConstellation starlightType, double amount) {
        TileCelestialCrystals tile = MiscUtils.getTileAt((IBlockAccess)world, pos, TileCelestialCrystals.class, false);
        if (tile != null) {
            tile.tryGrowth(0.5);
            IBlockState down = world.func_180495_p(pos.func_177977_b());
            if (down.func_177230_c() instanceof BlockCustomOre && down.func_177229_b(BlockCustomOre.ORE_TYPE) == BlockCustomOre.OreType.STARMETAL) {
                tile.tryGrowth(0.3);
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stack.func_77952_i()));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        BlockPos down = pos.func_177977_b();
        IBlockState downState = worldIn.func_180495_p(down);
        if (!downState.isSideSolid((IBlockAccess)worldIn, down, EnumFacing.UP)) {
            this.func_176226_b(worldIn, pos, state, 0);
            this.func_180663_b(worldIn, pos, state);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileCelestialCrystals te = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCelestialCrystals.class, true);
        if (te != null && !worldIn.field_72995_K) {
            PktParticleEvent event = new PktParticleEvent(PktParticleEvent.ParticleEventType.CELESTIAL_CRYSTAL_BURST, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            PacketChannel.CHANNEL.sendToAllAround((IMessage)event, PacketChannel.pointFromPos(worldIn, pos, 32.0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCelestialCrystals();
    }
}

