/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockCustomFlower
extends Block
implements BlockCustomName,
BlockVariants,
IShearable {
    public static final PropertyEnum<FlowerType> FLOWER_TYPE = PropertyEnum.func_177709_a((String)"flower", FlowerType.class);
    private static final AxisAlignedBB box = new AxisAlignedBB(0.09375, 0.0, 0.09375, 0.90625, 0.8125, 0.90625);
    private static final Random rand = new Random();

    public BlockCustomFlower() {
        super(Material.field_151585_k);
        this.func_149715_a(0.2f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K && !player.func_184812_l_()) {
            switch ((FlowerType)((Object)state.func_177229_b(FLOWER_TYPE))) {
                case GLOW_FLOWER: {
                    int i;
                    int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
                    int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)player.func_184614_ca());
                    if (looting > fortune) {
                        fortune = looting;
                    }
                    int size = 1;
                    for (i = 0; i < fortune; ++i) {
                        size += rand.nextInt(3) + 1;
                    }
                    for (i = 0; i < size; ++i) {
                        ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, new ItemStack(Items.field_151114_aO));
                    }
                    break;
                }
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canBlockStay(worldIn, pos);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        return downState.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return box;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FLOWER_TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FLOWER_TYPE, (Comparable)((Object)FlowerType.values()[meta]));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_176201_c(IBlockState state) {
        return ((FlowerType)((Object)state.func_177229_b(FLOWER_TYPE))).getMeta();
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        return ((FlowerType)((Object)this.func_176203_a(meta).func_177229_b(FLOWER_TYPE))).func_176610_l();
    }

    @Override
    public List<IBlockState> getValidStates() {
        LinkedList<IBlockState> states = new LinkedList<IBlockState>();
        for (FlowerType type : FlowerType.values()) {
            states.add(this.func_176223_P().func_177226_a(FLOWER_TYPE, (Comparable)((Object)type)));
        }
        return states;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((FlowerType)((Object)state.func_177229_b(FLOWER_TYPE))).func_176610_l();
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{ItemUtils.createBlockStack(world.func_180495_p(pos))});
    }

    public static enum FlowerType implements IStringSerializable
    {
        GLOW_FLOWER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public int getMeta() {
            return this.ordinal();
        }
    }
}

