/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockMachine;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileStructuralConnector;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStructural
extends BlockContainer
implements BlockCustomName,
BlockVariants {
    public static PropertyEnum<BlockType> BLOCK_TYPE = PropertyEnum.func_177709_a((String)"blocktype", BlockType.class);

    public BlockStructural() {
        super(Material.field_175972_I, MapColor.field_151660_b);
        this.func_149722_s();
        this.func_149672_a(SoundType.field_185853_f);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                IBlockState downState = world.func_180495_p(pos.func_177977_b());
                return BlockType.TELESCOPE_STRUCT.getSupportedState().func_177230_c().getSoundType(downState, world, pos, entity);
            }
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public String getHarvestTool(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))).getSupportedState().func_177230_c().getHarvestTool(((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))).getSupportedState());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos);
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                BlockType.TELESCOPE_STRUCT.getSupportedState().func_177230_c().addDestroyEffects(world, pos.func_177977_b(), manager);
                return true;
            }
        }
        return super.addDestroyEffects(world, pos, manager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                return new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        return field_185505_j;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (BlockType bt : BlockType.values()) {
            list.add(new ItemStack(item, 1, bt.ordinal()));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                return BlockType.TELESCOPE_STRUCT.getSupportedState().func_177230_c().func_180639_a(worldIn, pos.func_177977_b(), BlockType.TELESCOPE_STRUCT.getSupportedState(), playerIn, hand, heldItem, side, hitX, hitY, hitZ);
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                out.add(BlockMachine.MachineType.TELESCOPE.asStack());
            }
        }
        return out;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        switch ((BlockType)((Object)blockState.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                return BlockType.TELESCOPE_STRUCT.getSupportedState().func_185887_b(worldIn, pos.func_177977_b());
            }
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                return BlockType.TELESCOPE_STRUCT.getSupportedState().func_185887_b(world, pos.func_177977_b());
            }
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        state = world.func_180495_p(pos);
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                return BlockType.TELESCOPE_STRUCT.getSupportedState().func_177230_c().getPickBlock(BlockType.TELESCOPE_STRUCT.getSupportedState(), target, world, pos.func_177977_b(), player);
            }
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                if (!world.func_175623_d(pos.func_177977_b())) break;
                world.func_175698_g(pos);
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!(world instanceof World)) {
            super.onNeighborChange(world, pos, neighbor);
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                if (!world.func_175623_d(pos.func_177977_b())) break;
                ((World)world).func_175698_g(pos);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return meta < BlockType.values().length ? this.func_176223_P().func_177226_a(BLOCK_TYPE, (Comparable)((Object)BlockType.values()[meta])) : this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        BlockType type = (BlockType)((Object)state.func_177229_b(BLOCK_TYPE));
        return type == null ? 0 : type.ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BLOCK_TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))).getSupportedState().func_185914_p();
    }

    public boolean func_149686_d(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))).getSupportedState().func_185917_h();
    }

    public boolean func_149721_r(IBlockState state) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                return BlockType.TELESCOPE_STRUCT.getSupportedState().func_185915_l();
            }
        }
        return super.func_149721_r(state);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch ((BlockType)((Object)base_state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE_STRUCT: {
                return BlockType.TELESCOPE_STRUCT.getSupportedState().isSideSolid(world, pos.func_177977_b(), side);
            }
        }
        return super.isSideSolid(base_state, world, pos, side);
    }

    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        BlockType mt = (BlockType)((Object)this.func_176203_a(meta).func_177229_b(BLOCK_TYPE));
        return mt == null ? "null" : mt.func_176610_l();
    }

    @Override
    public List<IBlockState> getValidStates() {
        ArrayList<IBlockState> li = new ArrayList<IBlockState>(BlockType.values().length);
        for (BlockType bt : BlockType.values()) {
            li.add(this.func_176223_P().func_177226_a(BLOCK_TYPE, (Comparable)((Object)bt)));
        }
        return li;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))).func_176610_l();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileStructuralConnector();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileStructuralConnector();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public static enum BlockType implements IStringSerializable
    {
        TELESCOPE_STRUCT(BlocksAS.blockMachine.func_176223_P().func_177226_a(BlockMachine.MACHINE_TYPE, (Comparable)((Object)BlockMachine.MachineType.TELESCOPE)));

        private final IBlockState supportedState;

        private BlockType(IBlockState supportedState) {
            this.supportedState = supportedState;
        }

        public IBlockState getSupportedState() {
            return this.supportedState;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

