/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.network;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.block.BlockAttunementRelay;
import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.block.network.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.IVariantTileProvider;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import hellfirepvp.astralsorcery.common.util.struct.BlockDiscoverer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAltar
extends BlockStarlightNetwork
implements BlockCustomName,
BlockVariants {
    private static final AxisAlignedBB boxAttenuation = new AxisAlignedBB(-0.5, 0.0, -0.5, 1.5, 1.1875, 1.5);
    private static final AxisAlignedBB boxConstellation = new AxisAlignedBB(-0.75, 0.0, -0.75, 1.75, 1.5, 1.75);
    public static PropertyBool RENDER_FULLY = PropertyBool.func_177716_a((String)"render");
    public static PropertyEnum<AltarType> ALTAR_TYPE = PropertyEnum.func_177709_a((String)"altartype", AltarType.class);

    public BlockAltar() {
        super(Material.field_151576_e, MapColor.field_151670_w);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149752_b(25.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ALTAR_TYPE, (Comparable)((Object)AltarType.ALTAR_1)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileAltar ta;
        if (!worldIn.field_72995_K && (ta = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileAltar.class, true)) != null) {
            switch (ta.getAltarLevel()) {
                case DISCOVERY: {
                    AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.ALTAR_DISCOVERY, playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                case ATTUNEMENT: {
                    AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.ALTAR_ATTUNEMENT, playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                case CONSTELLATION_CRAFT: {
                    AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.ALTAR_CONSTELLATION, playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                case TRAIT_CRAFT: {
                    AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.ALTAR_TRAIT, playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
            }
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)RENDER_FULLY, (Comparable)Boolean.valueOf(false));
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(ALTAR_TYPE) != null;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (AltarType type : AltarType.values()) {
            if (type == AltarType.ALTAR_4 || type == AltarType.ALTAR_5) continue;
            ItemStack stack = new ItemStack(item, 1, type.ordinal());
            NBTTagCompound pers = NBTHelper.getPersistentData(stack);
            pers.func_74768_a("exp", 0);
            pers.func_74768_a("lvl", type.ordinal());
            list.add(stack);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        BlockAltar.startSearchForRelayUpdate(worldIn, pos);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        BlockAltar.startSearchForRelayUpdate(worldIn, pos);
    }

    public static void startSearchForRelayUpdate(World world, BlockPos pos) {
        Thread searchThread = new Thread(() -> {
            BlockArray relaysAndAltars = BlockDiscoverer.searchForBlocksAround(world, pos, 16, new BlockStateCheck.Block(new Block[]{BlocksAS.attunementRelay}));
            for (Map.Entry<BlockPos, BlockArray.BlockInformation> entry : relaysAndAltars.getPattern().entrySet()) {
                BlockAttunementRelay.startSearchRelayLinkThreadAt(world, entry.getKey(), false);
            }
        });
        searchThread.setName("AttRelay UpdateFinder at " + pos.toString());
        searchThread.start();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB box;
        AltarType type = (AltarType)((Object)state.func_177229_b(ALTAR_TYPE));
        if (type != null && (box = type.getBox()) != null) {
            return box;
        }
        return field_185505_j;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        AltarType type = (AltarType)((Object)state.func_177229_b(ALTAR_TYPE));
        if (type == null) {
            return null;
        }
        return type.provideTileEntity(world, state);
    }

    public IBlockState func_176203_a(int meta) {
        return meta < AltarType.values().length ? this.func_176223_P().func_177226_a(ALTAR_TYPE, (Comparable)((Object)AltarType.values()[meta])) : this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        AltarType type = (AltarType)((Object)state.func_177229_b(ALTAR_TYPE));
        return type == null ? 0 : type.ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ALTAR_TYPE, RENDER_FULLY});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound pers = NBTHelper.getPersistentData(stack);
        int exp = pers.func_74762_e("exp");
        int lvl = pers.func_74762_e("lvl");
        TileAltar ta = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileAltar.class, true);
        if (ta != null) {
            ta.onPlace(exp, TileAltar.AltarLevel.values()[lvl]);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (!worldIn.field_72995_K && te != null && te instanceof TileAltar) {
            ItemStack out = new ItemStack((Block)BlocksAS.blockAltar, 1, this.func_180651_a(state));
            int exp = ((TileAltar)te).getExperience();
            int levelOrdinal = ((TileAltar)te).getAltarLevel().ordinal();
            NBTTagCompound tag = NBTHelper.getPersistentData(out);
            tag.func_74768_a("exp", exp);
            tag.func_74768_a("lvl", levelOrdinal);
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, out);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new LinkedList<ItemStack>();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IBlockState actState = world.func_180495_p(pos);
        ItemStack stack = super.getPickBlock(actState, target, world, pos, player);
        TileAltar te = MiscUtils.getTileAt((IBlockAccess)world, pos, TileAltar.class, true);
        if (te != null) {
            int exp = te.getExperience();
            int levelOrdinal = te.getAltarLevel().ordinal();
            NBTTagCompound tag = NBTHelper.getPersistentData(stack);
            tag.func_74768_a("exp", exp);
            tag.func_74768_a("lvl", levelOrdinal);
        }
        return stack;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        return this.func_176203_a(meta);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        AltarType mt = (AltarType)((Object)this.func_176203_a(meta).func_177229_b(ALTAR_TYPE));
        return mt == null ? "null" : mt.func_176610_l();
    }

    @Override
    public List<IBlockState> getValidStates() {
        LinkedList<IBlockState> ret = new LinkedList<IBlockState>();
        for (AltarType type : AltarType.values()) {
            ret.add(this.func_176223_P().func_177226_a(ALTAR_TYPE, (Comparable)((Object)type)));
        }
        return ret;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((AltarType)((Object)state.func_177229_b(ALTAR_TYPE))).func_176610_l();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public static enum AltarType implements IStringSerializable,
    IVariantTileProvider
    {
        ALTAR_1((world, state) -> new TileAltar(TileAltar.AltarLevel.DISCOVERY)),
        ALTAR_2((world, state) -> new TileAltar(TileAltar.AltarLevel.ATTUNEMENT)),
        ALTAR_3((world, state) -> new TileAltar(TileAltar.AltarLevel.CONSTELLATION_CRAFT)),
        ALTAR_4((world, state) -> new TileAltar(TileAltar.AltarLevel.TRAIT_CRAFT)),
        ALTAR_5((world, state) -> new TileAltar(TileAltar.AltarLevel.ENDGAME));

        private final IVariantTileProvider provider;

        private AltarType(IVariantTileProvider provider) {
            this.provider = provider;
        }

        @Override
        public TileEntity provideTileEntity(World world, IBlockState state) {
            return this.provider.provideTileEntity(world, state);
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }

        public AxisAlignedBB getBox() {
            switch (this) {
                case ALTAR_1: {
                    return Block.field_185505_j;
                }
                case ALTAR_2: {
                    return Block.field_185505_j;
                }
                case ALTAR_3: {
                    return Block.field_185505_j;
                }
                case ALTAR_4: {
                    return null;
                }
                case ALTAR_5: {
                    return null;
                }
            }
            return null;
        }
    }
}

