/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerkMap;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerkMapRegistry;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public abstract class ConstellationBase
implements IConstellation {
    private List<StarLocation> starLocations = new ArrayList<StarLocation>();
    private List<StarConnection> connections = new ArrayList<StarConnection>();
    private final String name;

    public ConstellationBase(String name) {
        ModContainer mod = Loader.instance().activeModContainer();
        this.name = mod != null ? mod.getModId() + ".constellation." + name : "unknown.constellation." + name;
    }

    @Override
    public StarLocation addStar(int x, int y) {
        StarLocation star = new StarLocation(x &= 0x1E, y &= 0x1E);
        if (!this.starLocations.contains(star)) {
            this.starLocations.add(star);
            return star;
        }
        return null;
    }

    @Override
    public StarConnection addConnection(StarLocation star1, StarLocation star2) {
        if (star1.equals(star2)) {
            return null;
        }
        StarConnection sc = new StarConnection(star1, star2);
        if (!this.connections.contains(sc)) {
            this.connections.add(sc);
            return sc;
        }
        return null;
    }

    @Override
    public List<StarLocation> getStars() {
        return Collections.unmodifiableList(this.starLocations);
    }

    @Override
    public List<StarConnection> getStarConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    @Override
    public String getUnlocalizedName() {
        return this.name;
    }

    public String toString() {
        return "Constellation={name:" + this.getUnlocalizedName() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstellationBase that = (ConstellationBase)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class Minor
    extends ConstellationBase
    implements IMinorConstellation {
        private final List<MoonPhase> phases;

        public Minor(String name, MoonPhase ... applicablePhases) {
            super(name);
            this.phases = new ArrayList<MoonPhase>(applicablePhases.length);
            for (MoonPhase ph : applicablePhases) {
                if (ph == null) {
                    throw new IllegalArgumentException("[AstralSorcery] null MoonPhase passed to Minor constellation registration for " + name);
                }
                this.phases.add(ph);
            }
        }

        @Override
        public List<MoonPhase> getShowupMoonPhases() {
            return Collections.unmodifiableList(this.phases);
        }
    }

    public static abstract class WeakSpecial
    extends Weak
    implements IConstellationSpecialShowup {
        public WeakSpecial(String name) {
            super(name);
        }
    }

    public static class Weak
    extends ConstellationBase
    implements IWeakConstellation {
        public Weak(String name) {
            super(name);
        }

        @Override
        @Nullable
        public ConstellationEffect getRitualEffect() {
            return ConstellationEffectRegistry.getEffect(this);
        }
    }

    public static class Major
    extends Weak
    implements IMajorConstellation {
        public Major(String name) {
            super(name);
        }

        @Override
        @Nullable
        public ConstellationPerkMap getPerkMap() {
            return ConstellationPerkMapRegistry.getPerkMap(this);
        }
    }
}

