/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public abstract class CEffectEntityCollect<T extends Entity>
extends ConstellationEffect {
    protected final Class<T> classToSearch;
    protected final Predicate<T> searchFilter;
    protected double range;
    public static boolean enabled = true;
    private static AxisAlignedBB baseBoundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public CEffectEntityCollect(IWeakConstellation constellation, String cfgName, double defaultRange, Class<T> entityClass, Predicate<T> filter) {
        super(constellation, cfgName);
        this.classToSearch = entityClass;
        this.searchFilter = filter;
        this.range = defaultRange;
    }

    public List<T> collectEntities(World world, BlockPos pos) {
        if (!enabled) {
            return Lists.newArrayList();
        }
        return world.func_175647_a(this.classToSearch, baseBoundingBox.func_186670_a(pos), this.searchFilter);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        this.range = cfg.getFloat(this.getKey() + "Range", this.getConfigurationSection(), (float)this.range, 2.0f, 64.0f, "Defines the range in which the ritual will try to find entities");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        baseBoundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72314_b(this.range, this.range, this.range);
    }
}

