/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public abstract class CEffectPositionListGen<T extends CEffectGenListEntry>
extends ConstellationEffect {
    protected final Function<BlockPos, T> elementProvider;
    protected final int searchRange;
    protected final int maxCount;
    protected final Verifier verifier;
    private List<T> elements = new ArrayList<T>();

    public CEffectPositionListGen(IWeakConstellation constellation, String cfgName, int searchRange, int maxCount, Verifier verifier, Function<BlockPos, T> emptyElementProvider) {
        super(constellation, cfgName);
        this.elementProvider = emptyElementProvider;
        this.searchRange = searchRange;
        this.maxCount = maxCount;
        this.verifier = verifier;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    @Override
    public void clearCache() {
        this.elements.clear();
    }

    @Nullable
    public T getRandomElement(Random rand) {
        return (T)(this.elements.isEmpty() ? null : (CEffectGenListEntry)this.elements.get(rand.nextInt(this.elements.size())));
    }

    @Nullable
    public T getRandomElementByChance(Random rand) {
        if (this.elements.isEmpty()) {
            return null;
        }
        if (rand.nextInt((this.maxCount - this.elements.size()) / 4 + 1) == 0) {
            return this.getRandomElement(rand);
        }
        return null;
    }

    public boolean removeElement(T element) {
        return this.elements.remove(element);
    }

    public boolean offerNewElement(T element) {
        if (this.maxCount <= this.elements.size()) {
            return false;
        }
        if (this.containsElementAt(element.getPos())) {
            return false;
        }
        return this.elements.add(element);
    }

    public boolean findNewPosition(World world, BlockPos pos) {
        int offZ;
        int offY;
        int offX;
        BlockPos at;
        if (this.maxCount > this.elements.size() && MiscUtils.isChunkLoaded(world, new ChunkPos(at = pos.func_177982_a(offX = -this.searchRange + world.field_73012_v.nextInt(this.searchRange * 2), offY = -this.searchRange + world.field_73012_v.nextInt(this.searchRange * 2), offZ = -this.searchRange + world.field_73012_v.nextInt(this.searchRange * 2)))) && this.verifier.isValid(world, at) && !this.containsElementAt(at)) {
            this.elements.add(this.newElement(world, at));
            return true;
        }
        return false;
    }

    public T newElement(World world, BlockPos at) {
        return (T)((CEffectGenListEntry)this.elementProvider.apply(at));
    }

    private boolean containsElementAt(BlockPos pos) {
        for (CEffectGenListEntry e : this.elements) {
            if (!e.getPos().equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound cmp) {
        this.elements.clear();
        NBTTagList list = cmp.func_150295_c("positions", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            BlockPos pos = NBTUtils.readBlockPosFromNBT(tag);
            CEffectGenListEntry element = (CEffectGenListEntry)this.elementProvider.apply(pos);
            element.readFromNBT(tag);
            this.elements.add(element);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound cmp) {
        NBTTagList listPositions = new NBTTagList();
        for (CEffectGenListEntry elem : this.elements) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(elem.getPos(), tag);
            elem.writeToNBT(tag);
            listPositions.func_74742_a((NBTBase)tag);
        }
        cmp.func_74782_a("positions", (NBTBase)listPositions);
    }

    public static interface CEffectGenListEntry {
        public BlockPos getPos();

        public void readFromNBT(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound var1);
    }

    public static interface Verifier {
        public boolean isValid(World var1, BlockPos var2);
    }
}

