/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.controller.RenderOffsetControllerFornax;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.base.MeltInteraction;
import hellfirepvp.astralsorcery.common.base.WorldMeltables;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionListGen;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectFornax
extends CEffectPositionListGen<WorldMeltables.ActiveMeltableEntry> {
    public static boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static double failChance = 0.0;
    public static int searchRange = 12;
    public static int maxCount = 40;
    public static double meltDurationDivisor = 1.0;

    public CEffectFornax() {
        super(Constellations.fornax, "fornax", searchRange, maxCount, (world, pos) -> WorldMeltables.getMeltable(world, pos) != null, WorldMeltables.ActiveMeltableEntry::new);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        EntityFXFacingParticle p;
        if (rand.nextBoolean()) {
            p = EffectHelper.genericFlareParticle((double)((float)pos.func_177958_n() + rand.nextFloat() * 4.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5, pos.func_177956_o(), (double)((float)pos.func_177952_p() + rand.nextFloat() * 4.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5);
            p.motion(0.0, (double)rand.nextFloat() * 0.02 + 0.015, 0.0).gravity(0.004);
            p.setRenderOffsetController(new RenderOffsetControllerFornax()).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(0.25f).setColor(new Color(234, 59, 0)).setMaxAge(rand.nextInt(10) + 20);
        }
        if (rand.nextBoolean()) {
            p = EffectHelper.genericFlareParticle((double)((float)pos.func_177958_n() + rand.nextFloat() * 2.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5, pos.func_177956_o(), (double)((float)pos.func_177952_p() + rand.nextFloat() * 2.0f * (float)(rand.nextBoolean() ? 1 : -1)) + 0.5);
            p.gravity(0.004);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(0.25f).setColor(new Color(234, 59, 0)).setMaxAge(rand.nextInt(10) + 20);
        }
    }

    @Override
    public boolean playMainEffect(World world, BlockPos pos, float percStrength, boolean mayDoTraitEffect, @Nullable IMinorConstellation possibleTraitEffect) {
        BlockPos bp;
        if (!enabled) {
            return false;
        }
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        boolean changed = false;
        WorldMeltables.ActiveMeltableEntry entry = (WorldMeltables.ActiveMeltableEntry)this.getRandomElementByChance(rand);
        if (entry != null && MiscUtils.isChunkLoaded(world, new ChunkPos(bp = entry.getPos()))) {
            if (!entry.isValid(world, true)) {
                this.removeElement(entry);
                changed = true;
            } else {
                ++entry.counter;
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_MELT_BLOCK, bp.func_177958_n(), bp.func_177956_o(), bp.func_177952_p());
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, bp, 16.0));
                MeltInteraction melt = entry.getMeltable(world);
                if ((double)entry.counter >= (double)melt.getMeltTickDuration() / meltDurationDivisor) {
                    if (failChance > 0.0 && (double)rand.nextFloat() <= failChance) {
                        world.func_175698_g(bp);
                    } else {
                        melt.placeResultAt(world, bp);
                    }
                    this.removeElement(entry);
                }
                changed = true;
            }
        }
        if (this.findNewPosition(world, pos)) {
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean playTraitEffect(World world, BlockPos pos, IMinorConstellation traitType, float traitStrength) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playParticles(PktParticleEvent event) {
        Vector3 at = event.getVec();
        for (int i = 0; i < 3; ++i) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX() + (double)rand.nextFloat(), at.getY() + 0.2, at.getZ() + (double)rand.nextFloat());
            p.motion(0.0, 0.016 + (double)rand.nextFloat() * 0.02, 0.0);
            p.scale(0.2f).setColor(Color.RED);
        }
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        searchRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), 12, 1, 32, "Defines the radius (in blocks) in which the ritual will search for valid blocks to start to melt.");
        maxCount = cfg.getInt(this.getKey() + "Count", this.getConfigurationSection(), 40, 1, 4000, "Defines the amount of block-positions the ritual can cache and melt at max count");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        failChance = cfg.getFloat(this.getKey() + "FailChance", this.getConfigurationSection(), 0.0f, 0.0f, 1.0f, "Defines the chance (0% to 100% -> 0.0 to 1.0) if the block will be replaced with air instead of being properly melted into something.");
        meltDurationDivisor = cfg.getFloat(this.getKey() + "Divisor", this.getConfigurationSection(), 1.0f, 1.0E-4f, 200.0f, "Defines a multiplier used to determine how long it needs to melt a block. normal duration * durationMultiplier = actual duration");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

