/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionListGen;
import hellfirepvp.astralsorcery.common.constellation.effect.GenListEntries;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectOctans
extends CEffectPositionListGen<GenListEntries.CounterMaxListEntry> {
    public static boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static int searchRange = 12;
    public static int maxFishingGrounds = 20;
    public static int minFishTickTime = 1000;
    public static int maxFishTickTime = 5000;

    public CEffectOctans() {
        super(Constellations.octans, "octans", searchRange, maxFishingGrounds, (world, pos) -> {
            IBlockState at = world.func_180495_p(pos);
            return at.func_177230_c() instanceof BlockLiquid && at.func_177230_c().func_149688_o(at).equals(Material.field_151586_h) && (Integer)at.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && world.func_175623_d(pos.func_177984_a());
        }, pos -> new GenListEntries.CounterMaxListEntry((BlockPos)pos, minFishTickTime + rand.nextInt(maxFishTickTime - minFishTickTime + 1)));
    }

    @Override
    public boolean playMainEffect(World world, BlockPos pos, float percStrength, boolean mayDoTraitEffect, @Nullable IMinorConstellation possibleTraitEffect) {
        if (!enabled) {
            return false;
        }
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        boolean changed = false;
        GenListEntries.CounterMaxListEntry entry = (GenListEntries.CounterMaxListEntry)this.getRandomElementByChance(rand);
        if (entry != null && MiscUtils.isChunkLoaded(world, new ChunkPos(entry.getPos()))) {
            if (!this.verifier.isValid(world, entry.getPos())) {
                this.removeElement(entry);
                changed = true;
            } else {
                do {
                    ++entry.counter;
                    percStrength = (float)((double)percStrength - 0.1);
                } while (rand.nextFloat() < percStrength);
                changed = true;
                if (entry.counter >= entry.maxCount) {
                    Vector3 dropLoc = new Vector3(entry.getPos()).add(0.5, 0.85, 0.5);
                    entry.maxCount = minFishTickTime + rand.nextInt(maxFishTickTime - minFishTickTime + 1);
                    entry.counter = 0;
                    LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
                    builder.func_186469_a((float)rand.nextInt(2) * rand.nextFloat());
                    for (ItemStack loot : world.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(rand, builder.func_186471_a())) {
                        EntityItem ei = ItemUtils.dropItemNaturally(world, dropLoc.getX(), dropLoc.getY(), dropLoc.getZ(), loot);
                        ei.field_70181_x = Math.abs(ei.field_70181_x);
                    }
                }
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_WATER_FISH, (Vec3i)entry.getPos());
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, entry.getPos(), 8.0));
            }
        }
        if (this.findNewPosition(world, pos)) {
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean playTraitEffect(World world, BlockPos pos, IMinorConstellation traitType, float traitStrength) {
        return false;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        searchRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), 12, 1, 32, "Defines the radius (in blocks) in which the ritual will search for water ");
        maxFishingGrounds = cfg.getInt(this.getKey() + "Count", this.getConfigurationSection(), 20, 1, 4000, "Defines the amount of crops the ritual can cache at max. count");
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
        minFishTickTime = cfg.getInt(this.getKey() + "MinFishTickTime", this.getConfigurationSection(), 100, 20, Integer.MAX_VALUE, "Defines the minimum default tick-time until a fish may be fished by the ritual. gets reduced internally the more starlight was provided at the ritual.");
        maxFishTickTime = cfg.getInt(this.getKey() + "MaxFishTickTime", this.getConfigurationSection(), 500, 20, Integer.MAX_VALUE, "Defines the maximum default tick-time until a fish may be fished by the ritual. gets reduced internally the more starlight was provided at the ritual. Has to be bigger as the minimum time; if it isn't it'll be set to the minimum.");
        if (maxFishTickTime < minFishTickTime) {
            maxFishTickTime = minFishTickTime;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playParticles(PktParticleEvent event) {
        Vector3 at = event.getVec();
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX() + (double)rand.nextFloat(), at.getY() + (double)rand.nextFloat(), at.getZ() + (double)rand.nextFloat());
        p.motion(0.0, 0.03 + (double)rand.nextFloat() * 0.01, 0.0).setMaxAge(5 + rand.nextInt(5));
        p.scale(0.2f).setColor(Color.CYAN).gravity(-0.03);
    }
}

