/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.util.ExtendedChainingPlayerController;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktUpdateReach;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkCreationReach
extends ConstellationPerk {
    private static float reachModifier = 3.5f;

    public PerkCreationReach() {
        super("CRE_REACH", ConstellationPerk.Target.PLAYER_TICK);
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side == Side.SERVER) {
            if (!this.isCooldownActiveForPlayer(player) && player instanceof EntityPlayerMP) {
                double reach = Math.max(5.0, ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + (double)reachModifier);
                ((EntityPlayerMP)player).field_71134_c.setBlockReachDistance(reach);
                PktUpdateReach pkt = new PktUpdateReach(true, reachModifier);
                PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
            }
            this.setCooldownActiveForPlayer(player, 30);
        }
    }

    @Override
    public void onTimeout(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            double reach = Math.max(5.0, ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() - (double)reachModifier);
            ((EntityPlayerMP)player).field_71134_c.setBlockReachDistance(reach);
            PktUpdateReach pkt = new PktUpdateReach(false, 0.0f);
            PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateReach(boolean apply, float modifierIn) {
        EntityPlayerSP pl = Minecraft.func_71410_x().field_71439_g;
        PlayerControllerMP ctrl = Minecraft.func_71410_x().field_71442_b;
        if (pl != null && ctrl != null) {
            if (!(ctrl instanceof ExtendedChainingPlayerController)) {
                ExtendedChainingPlayerController ovr = new ExtendedChainingPlayerController(ctrl);
                boolean isFlying = pl.field_71075_bZ.field_75100_b;
                boolean allowFlight = pl.field_71075_bZ.field_75101_c;
                ovr.func_78746_a(ctrl.func_178889_l());
                pl.field_71075_bZ.field_75100_b = isFlying;
                pl.field_71075_bZ.field_75101_c = allowFlight;
                Minecraft.func_71410_x().field_71442_b = ovr;
            }
            ExtendedChainingPlayerController ctr = (ExtendedChainingPlayerController)Minecraft.func_71410_x().field_71442_b;
            if (apply) {
                ctr.setReachModifier(modifierIn);
            } else {
                ctr.setReachModifier(0.0f);
            }
        } else {
            AstralSorcery.proxy.scheduleClientside(() -> PerkCreationReach.updateReach(apply, modifierIn));
        }
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        reachModifier = cfg.getFloat(this.getKey() + "ReachModifier", this.getConfigurationSection(), 2.5f, 0.0f, 200.0f, "Sets the reach modifier that gets applied when the player has this perk. (Too high values might cause issues.)");
    }
}

