/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class PerkDamageReflect
extends ConstellationPerk {
    public static int reflectChance = 5;
    public static float reflectPerc = 0.6f;

    public PerkDamageReflect() {
        super("DMG_REFLECT", ConstellationPerk.Target.ENTITY_HURT);
    }

    @Override
    public float onEntityHurt(EntityPlayer hurt, DamageSource source, float dmgIn) {
        Entity cause;
        if (rand.nextInt(reflectChance) == 0 && (cause = source.func_76346_g()) != null && cause instanceof EntityLivingBase) {
            cause.func_70097_a(DamageSource.func_76365_a((EntityPlayer)hurt), dmgIn * reflectPerc);
        }
        return dmgIn;
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        reflectChance = cfg.getInt(this.getKey() + "ReflectChance", this.getConfigurationSection(), reflectChance, 1, 5000, "Defines the chance that a incoming attack (if it can be resolved to an attacker) can be reflected (random.nextInt(chance) == 0 check)");
        reflectPerc = cfg.getFloat(this.getKey() + "ReflectPercentage", this.getConfigurationSection(), reflectPerc, 0.001f, 1.0f, "Defines the percentage of damage that the attacker will also take upon attacking the player.");
        reflectChance = Math.max(1, reflectChance);
        reflectPerc = MathHelper.func_76131_a((float)reflectPerc, (float)0.001f, (float)1.0f);
    }
}

