/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.item.ItemGatedVisibility;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemHandle {
    public static boolean ignoreGatingRequirement = true;
    public final Type handleType;
    private List<ItemStack> applicableItems = new LinkedList<ItemStack>();
    private String oreDictName = null;
    private FluidStack fluidTypeAndAmount = null;

    private ItemHandle(Type type) {
        this.handleType = type;
    }

    public ItemHandle(String oreDictName) {
        this.oreDictName = oreDictName;
        this.handleType = Type.OREDICT;
    }

    public ItemHandle(Fluid fluid) {
        this.fluidTypeAndAmount = new FluidStack(fluid, 1000);
        this.handleType = Type.FLUID;
    }

    public ItemHandle(Fluid fluid, int mbAmount) {
        this.fluidTypeAndAmount = new FluidStack(fluid, mbAmount);
        this.handleType = Type.FLUID;
    }

    public ItemHandle(FluidStack compareStack) {
        this.fluidTypeAndAmount = compareStack.copy();
        this.handleType = Type.FLUID;
    }

    public ItemHandle(@Nonnull ItemStack matchStack) {
        this.applicableItems.add(ItemUtils.copyStackWithSize(matchStack, matchStack.field_77994_a));
        this.handleType = Type.STACK;
    }

    public ItemHandle(List<ItemStack> matchStacks) {
        for (ItemStack stack : matchStacks) {
            if (stack == null || stack.func_77973_b() == null) continue;
            this.applicableItems.add(ItemUtils.copyStackWithSize(stack, stack.field_77994_a));
        }
        this.handleType = Type.STACK;
    }

    public static ItemHandle getCrystalVariant(boolean hasToBeTuned, boolean hasToBeCelestial) {
        if (hasToBeTuned) {
            if (hasToBeCelestial) {
                return new ItemHandle(new ItemStack((Item)ItemsAS.tunedCelestialCrystal));
            }
            ItemHandle handle = new ItemHandle(new ItemStack((Item)ItemsAS.tunedRockCrystal));
            handle.applicableItems.add(new ItemStack((Item)ItemsAS.tunedCelestialCrystal));
            return handle;
        }
        if (hasToBeCelestial) {
            ItemHandle handle = new ItemHandle(new ItemStack((Item)ItemsAS.celestialCrystal));
            handle.applicableItems.add(new ItemStack((Item)ItemsAS.tunedCelestialCrystal));
            return handle;
        }
        ItemHandle handle = new ItemHandle(new ItemStack((Item)ItemsAS.rockCrystal));
        handle.applicableItems.add(new ItemStack((Item)ItemsAS.celestialCrystal));
        handle.applicableItems.add(new ItemStack((Item)ItemsAS.tunedRockCrystal));
        handle.applicableItems.add(new ItemStack((Item)ItemsAS.tunedCelestialCrystal));
        return handle;
    }

    public List<ItemStack> getApplicableItems() {
        if (this.oreDictName != null) {
            List stacks = OreDictionary.getOres((String)this.oreDictName);
            LinkedList<ItemStack> out = new LinkedList<ItemStack>();
            for (ItemStack oreDictIn : stacks) {
                if (oreDictIn.func_77952_i() == Short.MAX_VALUE && !oreDictIn.func_77984_f()) {
                    oreDictIn.func_77973_b().func_150895_a(oreDictIn.func_77973_b(), CreativeTabs.field_78030_b, out);
                    continue;
                }
                out.add(oreDictIn);
            }
            return out;
        }
        if (this.fluidTypeAndAmount != null) {
            return Lists.newArrayList((Object[])new ItemStack[]{UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluidTypeAndAmount.getFluid())});
        }
        return Lists.newArrayList(this.applicableItems);
    }

    public Object getObjectForRecipe() {
        if (this.oreDictName != null) {
            return this.oreDictName;
        }
        if (this.fluidTypeAndAmount != null) {
            return UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)this.fluidTypeAndAmount.getFluid());
        }
        return this.applicableItems;
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getApplicableItemsForRender() {
        List<ItemStack> applicable = this.getApplicableItems();
        Iterator<ItemStack> iterator = applicable.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (stack == null || stack.func_77973_b() == null) continue;
            Item i = stack.func_77973_b();
            if (ignoreGatingRequirement || !(i instanceof ItemGatedVisibility) || ((ItemGatedVisibility)i).isSupposedToSeeInRender(stack)) continue;
            iterator.remove();
        }
        return applicable;
    }

    @Nullable
    public String getOreDictName() {
        return this.oreDictName;
    }

    @Nullable
    public FluidStack getFluidTypeAndAmount() {
        return this.fluidTypeAndAmount;
    }

    public boolean matchCrafting(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        switch (this.handleType) {
            case OREDICT: {
                for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                    String name = OreDictionary.getOreName((int)id);
                    if (name == null || !name.equals(this.oreDictName)) continue;
                    return true;
                }
                return false;
            }
            case STACK: {
                for (ItemStack applicable : this.applicableItems) {
                    if (!ItemUtils.stackEqualsNonNBT(applicable, stack)) continue;
                    return true;
                }
                return false;
            }
            case FLUID: {
                return ItemUtils.drainFluidFromItem(stack, this.fluidTypeAndAmount, false) != null;
            }
        }
        return false;
    }

    public void serialize(ByteBuf byteBuf) {
        byteBuf.writeInt(this.handleType.ordinal());
        switch (this.handleType) {
            case OREDICT: {
                ByteBufUtils.writeString(byteBuf, this.oreDictName);
                break;
            }
            case STACK: {
                byteBuf.writeInt(this.applicableItems.size());
                for (ItemStack applicableItem : this.applicableItems) {
                    ByteBufUtils.writeItemStack(byteBuf, applicableItem);
                }
                break;
            }
            case FLUID: {
                ByteBufUtils.writeFluidStack(byteBuf, this.fluidTypeAndAmount);
            }
        }
    }

    public static ItemHandle deserialize(ByteBuf byteBuf) {
        Type type = Type.values()[byteBuf.readInt()];
        ItemHandle handle = new ItemHandle(type);
        switch (type) {
            case OREDICT: {
                handle.oreDictName = ByteBufUtils.readString(byteBuf);
                break;
            }
            case STACK: {
                int amt = byteBuf.readInt();
                for (int i = 0; i < amt; ++i) {
                    handle.applicableItems.add(ByteBufUtils.readItemStack(byteBuf));
                }
                break;
            }
            case FLUID: {
                handle.fluidTypeAndAmount = ByteBufUtils.readFluidStack(byteBuf);
            }
        }
        return handle;
    }

    public static enum Type {
        OREDICT,
        STACK,
        FLUID;

    }
}

