/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting;

import hellfirepvp.astralsorcery.common.data.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedLightProximityRecipe
implements IRecipe {
    public static BlockPos clientWorkbenchPosition = null;
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    protected ItemStack output = null;
    protected Object[] input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;

    public ShapedLightProximityRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapedLightProximityRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapedLightProximityRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else if (in instanceof List) {
                itemMap.put(chr, in);
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (!this.vanillaMatch(inv, world)) {
            return false;
        }
        Container c = inv.field_70465_c;
        if (!(c instanceof ContainerWorkbench)) {
            return false;
        }
        ContainerWorkbench workbench = (ContainerWorkbench)c;
        BlockPos pos = workbench.field_178145_h;
        if (pos == null) {
            return false;
        }
        if (world.field_72995_K) {
            GuiScreen sc = Minecraft.func_71410_x().field_71462_r;
            if (sc == null || !(sc instanceof GuiCrafting) || clientWorkbenchPosition == null) {
                return false;
            }
            if (!((DataLightBlockEndpoints)SyncDataHolder.getDataClient("StarlightNetworkEndpoints")).doesPositionReceiveStarlightClient(world, clientWorkbenchPosition)) {
                return false;
            }
        } else if (!((DataLightBlockEndpoints)SyncDataHolder.getDataServer("StarlightNetworkEndpoints")).doesPositionReceiveStarlightServer(world, pos)) {
            return false;
        }
        return true;
    }

    private boolean vanillaMatch(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public Object[] getInput() {
        return this.input;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

