/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.crafting.IAccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.IGatedRecipe;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.RecipeAdapter;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractCacheableRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractAltarRecipe {
    private int experiencePerCraft = 5;
    private int passiveStarlightRequirement;
    private final TileAltar.AltarLevel neededLevel;
    private final IAccessibleRecipe recipe;
    private final ItemStack out;
    private int uniqueRecipeId = -1;

    public AbstractAltarRecipe(TileAltar.AltarLevel neededLevel, AbstractCacheableRecipe recipe) {
        this(neededLevel, recipe.make());
    }

    public AbstractAltarRecipe(TileAltar.AltarLevel neededLevel, IAccessibleRecipe recipe) {
        this.neededLevel = neededLevel;
        this.recipe = recipe;
        this.out = recipe.func_77571_b();
    }

    public final void updateUniqueId(int id) {
        this.uniqueRecipeId = id;
    }

    public final int getUniqueRecipeId() {
        return this.uniqueRecipeId;
    }

    @Nonnull
    public ItemStack getOutputForRender() {
        return ItemUtils.copyStackWithSize(this.out, this.out.field_77994_a);
    }

    public IAccessibleRecipe getNativeRecipe() {
        return this.recipe;
    }

    @Nullable
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        return ItemUtils.copyStackWithSize(this.out, this.out.field_77994_a);
    }

    @Nullable
    public ItemStack getOutputForMatching() {
        return ItemUtils.copyStackWithSize(this.out, this.out.field_77994_a);
    }

    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        if (!ignoreStarlightRequirement && !this.fulfillesStarlightRequirement(altar)) {
            return false;
        }
        if (this instanceof IGatedRecipe && altar.func_145831_w().field_72995_K && !((IGatedRecipe)((Object)this)).hasProgressionClient()) {
            return false;
        }
        if (this instanceof INighttimeRecipe && !ConstellationSkyHandler.getInstance().isNight(altar.func_145831_w())) {
            return false;
        }
        ItemStack[] altarInv = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            altarInv[i] = invHandler.getStackInSlot(i);
        }
        RecipeAdapter adapter = new RecipeAdapter(altar.getCraftingRecipeWidth(), altar.getCraftingRecipeHeight());
        adapter.fill(altarInv);
        return this.recipe.func_77569_a(adapter, altar.func_145831_w());
    }

    public boolean fulfillesStarlightRequirement(TileAltar altar) {
        return altar.getStarlightStored() >= this.getPassiveStarlightRequired();
    }

    public AbstractAltarRecipe setPassiveStarlightRequirement(int starlightRequirement) {
        this.passiveStarlightRequirement = starlightRequirement;
        return this;
    }

    public int getPassiveStarlightRequired() {
        return this.passiveStarlightRequirement;
    }

    public AbstractAltarRecipe setCraftExperience(int exp) {
        this.experiencePerCraft = exp;
        return this;
    }

    public boolean allowsForChaining() {
        return true;
    }

    public int getCraftExperience() {
        return this.experiencePerCraft;
    }

    public float getCraftExperienceMultiplier() {
        return 1.0f;
    }

    public TileAltar.AltarLevel getNeededLevel() {
        return this.neededLevel;
    }

    public int craftingTickTime() {
        return 100;
    }

    public boolean mayDecrement(TileAltar ta, ShapedRecipeSlot slot) {
        ItemHandle handle = this.recipe.getExpectedStackHandle(slot);
        return handle == null || handle.getFluidTypeAndAmount() == null;
    }

    public boolean mayDecrement(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
        if (!(this instanceof AttunementRecipe)) {
            return true;
        }
        AttunementRecipe thisRecipe = (AttunementRecipe)this;
        ItemHandle handle = thisRecipe.getAttItemHandle(slot);
        return handle == null || handle.getFluidTypeAndAmount() == null;
    }

    public boolean mayDecrement(TileAltar ta, ConstellationRecipe.ConstellationAtlarSlot slot) {
        if (!(this instanceof ConstellationRecipe)) {
            return true;
        }
        ConstellationRecipe thisRecipe = (ConstellationRecipe)this;
        ItemHandle handle = thisRecipe.getCstItemHandle(slot);
        return handle == null || handle.getFluidTypeAndAmount() == null;
    }

    public void handleItemConsumption(TileAltar ta, ShapedRecipeSlot slot) {
        ItemStack result;
        ItemHandle handle = this.recipe.getExpectedStackHandle(slot);
        if (handle == null) {
            return;
        }
        TileReceiverBaseInventory.ItemHandlerTile inventory = ta.getInventoryHandler();
        ItemStack stack = inventory.getStackInSlot(slot.getSlotID());
        if (stack != null && (result = ItemUtils.drainFluidFromItem(stack, handle.getFluidTypeAndAmount(), true)) != null) {
            inventory.setStackInSlot(slot.getSlotID(), result);
        }
    }

    public void handleItemConsumption(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
        ItemStack result;
        if (!(this instanceof AttunementRecipe)) {
            return;
        }
        AttunementRecipe thisRecipe = (AttunementRecipe)this;
        ItemHandle handle = thisRecipe.getAttItemHandle(slot);
        if (handle == null) {
            return;
        }
        TileReceiverBaseInventory.ItemHandlerTile inventory = ta.getInventoryHandler();
        ItemStack stack = inventory.getStackInSlot(slot.getSlotId());
        if (stack != null && (result = ItemUtils.drainFluidFromItem(stack, handle.getFluidTypeAndAmount(), true)) != null) {
            inventory.setStackInSlot(slot.getSlotId(), result);
        }
    }

    public void handleItemConsumption(TileAltar ta, ConstellationRecipe.ConstellationAtlarSlot slot) {
        ItemStack result;
        if (!(this instanceof ConstellationRecipe)) {
            return;
        }
        ConstellationRecipe thisRecipe = (ConstellationRecipe)this;
        ItemHandle handle = thisRecipe.getCstItemHandle(slot);
        if (handle == null) {
            return;
        }
        TileReceiverBaseInventory.ItemHandlerTile inventory = ta.getInventoryHandler();
        ItemStack stack = inventory.getStackInSlot(slot.getSlotId());
        if (stack != null && (result = ItemUtils.drainFluidFromItem(stack, handle.getFluidTypeAndAmount(), true)) != null) {
            inventory.setStackInSlot(slot.getSlotId(), result);
        }
    }

    public void applyOutputModificationsServer(TileAltar ta, Random rand) {
    }

    public void onCraftServerFinish(TileAltar altar, Random rand) {
    }

    public void onCraftServerTick(TileAltar altar, ActiveCraftingTask.CraftingState state, int tick, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onCraftTESRRender(TileAltar te, double x, double y, double z, float partialTicks) {
    }
}

