/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.ICraftingProgress;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ActiveCraftingTask {
    private final AbstractAltarRecipe recipeToCraft;
    private final UUID playerCraftingUUID;
    private int ticksCrafting = 0;
    private CraftingState state;
    private NBTTagCompound craftingData = new NBTTagCompound();

    public ActiveCraftingTask(AbstractAltarRecipe recipeToCraft, UUID playerCraftingUUID) {
        this.recipeToCraft = recipeToCraft;
        this.playerCraftingUUID = playerCraftingUUID;
        this.state = CraftingState.ACTIVE;
    }

    public CraftingState getState() {
        return this.state;
    }

    public void setState(CraftingState state) {
        this.state = state;
    }

    public boolean shouldPersist() {
        return this.recipeToCraft instanceof TraitRecipe;
    }

    public UUID getPlayerCraftingUUID() {
        return this.playerCraftingUUID;
    }

    public NBTTagCompound getCraftingData() {
        return this.craftingData;
    }

    @Nullable
    public EntityPlayer tryGetCraftingPlayerServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerCraftingUUID);
    }

    public boolean tick(TileAltar altar) {
        if (this.recipeToCraft instanceof ICraftingProgress && !((ICraftingProgress)((Object)this.recipeToCraft)).tryProcess(altar, this, this.craftingData, this.ticksCrafting)) {
            return false;
        }
        ++this.ticksCrafting;
        return true;
    }

    public int getTicksCrafting() {
        return this.ticksCrafting;
    }

    public AbstractAltarRecipe getRecipeToCraft() {
        return this.recipeToCraft;
    }

    public boolean isFinished() {
        return this.ticksCrafting >= this.recipeToCraft.craftingTickTime();
    }

    @Nullable
    public static ActiveCraftingTask deserialize(NBTTagCompound compound) {
        int recipeId = compound.func_74762_e("recipeId");
        AbstractAltarRecipe recipe = AltarRecipeRegistry.getRecipe(recipeId);
        if (recipe == null) {
            AstralSorcery.log.info("Recipe with unknown/invalid ID found: " + recipeId);
            return null;
        }
        UUID uuidCraft = compound.func_186857_a("crafterUUID");
        int tick = compound.func_74762_e("recipeTick");
        CraftingState state = CraftingState.values()[compound.func_74762_e("craftingState")];
        ActiveCraftingTask task = new ActiveCraftingTask(recipe, uuidCraft);
        task.ticksCrafting = tick;
        task.setState(state);
        task.craftingData = compound.func_74775_l("craftingData");
        return task;
    }

    @Nonnull
    public NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("recipeId", this.getRecipeToCraft().getUniqueRecipeId());
        compound.func_74768_a("recipeTick", this.getTicksCrafting());
        compound.func_186854_a("crafterUUID", this.getPlayerCraftingUUID());
        compound.func_74768_a("craftingState", this.getState().ordinal());
        compound.func_74782_a("craftingData", (NBTBase)this.craftingData);
        return compound;
    }

    public static enum CraftingState {
        ACTIVE,
        WAITING,
        PAUSED;

    }
}

