/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.Vec3i;

public class AttunementAltarRecipe
extends AttunementRecipe
implements INighttimeRecipe {
    private static Vector3[] offsetPillarsT2 = new Vector3[]{new Vector3(3, 2, 3), new Vector3(-3, 2, 3), new Vector3(3, 2, -3), new Vector3(-3, 2, -3)};
    private static Vector3[] offsetPillarsT3 = new Vector3[]{new Vector3(4, 3, 4), new Vector3(-4, 3, 4), new Vector3(4, 3, -4), new Vector3(-4, 3, -4)};

    public AttunementAltarRecipe() {
        super(new ShapedRecipe((Block)BlocksAS.attunementAltar).addPart(ItemHandle.getCrystalVariant(false, false), ShapedRecipeSlot.UPPER_CENTER).addPart(ItemCraftingComponent.MetaType.STARMETAL_INGOT.asStack(), ShapedRecipeSlot.LEFT, ShapedRecipeSlot.RIGHT).addPart((Block)BlocksAS.attunementRelay, ShapedRecipeSlot.LOWER_CENTER).addPart(BlockMarble.MarbleBlockType.RUNED.asStack(), ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_RIGHT));
        this.setAttItem(ItemCraftingComponent.MetaType.AQUAMARINE.asStack(), AttunementRecipe.AttunementAltarSlot.UPPER_LEFT, AttunementRecipe.AttunementAltarSlot.UPPER_RIGHT);
        this.setAttItem(BlockMarble.MarbleBlockType.RUNED.asStack(), AttunementRecipe.AttunementAltarSlot.LOWER_LEFT, AttunementRecipe.AttunementAltarSlot.LOWER_RIGHT);
    }

    @Override
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 randomPos = new Vector3(altar);
            randomPos.add(rand.nextFloat() * 7.0f - 3.0f, 0.1, rand.nextFloat() * 7.0f - 3.0f);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(randomPos.getX(), randomPos.getY(), randomPos.getZ());
            p.scale(0.7f).gravity(0.02);
            if (tick % 50L == 0L) {
                Vector3 vec = new Vector3(altar).add(0.5, 0.5, 0.5);
                switch (altar.getAltarLevel()) {
                    case DISCOVERY: {
                        break;
                    }
                    case ATTUNEMENT: {
                        for (Vector3 offset : offsetPillarsT2) {
                            EffectHandler.getInstance().lightbeam(offset.clone().add((Vec3i)altar.func_174877_v()).add(0.5, 0.5, 0.5), vec, 1.2f);
                        }
                        break;
                    }
                    case CONSTELLATION_CRAFT: {
                        for (Vector3 offset : offsetPillarsT3) {
                            EffectHandler.getInstance().lightbeam(offset.clone().add((Vec3i)altar.func_174877_v()).add(0.5, 0.5, 0.5), vec, 1.2f);
                        }
                        break;
                    }
                    case TRAIT_CRAFT: {
                        break;
                    }
                }
            }
            if (rand.nextInt(10) == 0) {
                Vector3 from = new Vector3(altar).add(0.5, -0.6, 0.5);
                MiscUtils.applyRandomOffset(from, rand, 1.8f);
                from.setY((double)altar.func_174877_v().func_177956_o() - 0.6 + (double)(1.0f * rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)));
                EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(5 + rand.nextInt(3)), from, 1.0);
                lightbeam.setMaxAge(64);
            }
        }
    }
}

