/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.block.ItemCollectorCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class CollectorCrystalRecipe
extends ConstellationRecipe {
    private final boolean celestial;
    private final ItemStack renderOutput;

    public CollectorCrystalRecipe(boolean celestial) {
        super(new ShapedRecipe((Block)(celestial ? BlocksAS.celestialCollectorCrystal : BlocksAS.collectorCrystal)).addPart(celestial ? ItemsAS.tunedCelestialCrystal : ItemsAS.tunedRockCrystal, ShapedRecipeSlot.CENTER));
        this.setAttItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), AttunementRecipe.AttunementAltarSlot.values());
        this.setCstItem(ItemCraftingComponent.MetaType.STARDUST.asStack(), ConstellationRecipe.ConstellationAtlarSlot.UP_UP_LEFT, ConstellationRecipe.ConstellationAtlarSlot.UP_UP_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_LEFT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_RIGHT);
        this.setCstItem(ItemsAS.illuminationPowder, ConstellationRecipe.ConstellationAtlarSlot.UP_LEFT_LEFT, ConstellationRecipe.ConstellationAtlarSlot.UP_RIGHT_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_LEFT_LEFT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_RIGHT_RIGHT);
        this.celestial = celestial;
        ItemStack stack = new ItemStack((Block)(celestial ? BlocksAS.celestialCollectorCrystal : BlocksAS.collectorCrystal));
        ItemCollectorCrystal.setType(stack, celestial ? BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL : BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL);
        this.renderOutput = stack;
        this.setPassiveStarlightRequirement(2600);
    }

    @Override
    @Nullable
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        ItemStack center = ((ItemHandle)centralGridMap.get((Object)ShapedRecipeSlot.CENTER)).getApplicableItems().get(0);
        if (center == null || center.func_77973_b() == null || !(center.func_77973_b() instanceof ItemTunedCrystalBase)) {
            return null;
        }
        ItemStack out = super.getOutput(centralGridMap, altar);
        IWeakConstellation attuned = ItemTunedCrystalBase.getMainConstellation(center);
        CrystalProperties prop = CrystalProperties.getCrystalProperties(center);
        if (attuned == null || prop == null) {
            return null;
        }
        ItemCollectorCrystal.setConstellation(out, attuned);
        CrystalProperties.applyCrystalProperties(out, prop);
        ItemCollectorCrystal.setType(out, this.celestial ? BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL : BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL);
        return out;
    }

    @Override
    @Nonnull
    public ItemStack getOutputForRender() {
        return this.renderOutput;
    }
}

