/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.crafting.IAccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractCacheableRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConstellationRecipe
extends AttunementRecipe {
    private static Vector3[] offsetPillars = new Vector3[]{new Vector3(4, 3, 4), new Vector3(-4, 3, 4), new Vector3(4, 3, -4), new Vector3(-4, 3, -4)};
    private Map<ConstellationAtlarSlot, ItemHandle> matchStacks = new HashMap<ConstellationAtlarSlot, ItemHandle>();

    protected ConstellationRecipe(TileAltar.AltarLevel neededLevel, IAccessibleRecipe recipe) {
        super(neededLevel, recipe);
    }

    protected ConstellationRecipe(TileAltar.AltarLevel neededLevel, AbstractCacheableRecipe recipe) {
        super(neededLevel, recipe);
    }

    public ConstellationRecipe(AbstractCacheableRecipe recipe) {
        this(recipe.make());
    }

    public ConstellationRecipe(IAccessibleRecipe recipe) {
        super(TileAltar.AltarLevel.CONSTELLATION_CRAFT, recipe);
        this.setPassiveStarlightRequirement(3200);
    }

    public ConstellationRecipe setCstItem(Item i, ConstellationAtlarSlot ... slots) {
        return this.setCstItem(new ItemStack(i), slots);
    }

    public ConstellationRecipe setCstItem(Block b, ConstellationAtlarSlot ... slots) {
        return this.setCstItem(new ItemStack(b), slots);
    }

    public ConstellationRecipe setCstItem(ItemStack stack, ConstellationAtlarSlot ... slots) {
        return this.setCstItem(new ItemHandle(stack), slots);
    }

    public ConstellationRecipe setCstItem(String oreDict, ConstellationAtlarSlot ... slots) {
        return this.setCstItem(new ItemHandle(oreDict), slots);
    }

    public ConstellationRecipe setCstItem(FluidStack fluid, ConstellationAtlarSlot ... slots) {
        return this.setCstItem(new ItemHandle(fluid), slots);
    }

    public ConstellationRecipe setCstItem(Fluid fluid, int mbAmount, ConstellationAtlarSlot ... slots) {
        return this.setCstItem(new FluidStack(fluid, mbAmount), slots);
    }

    public ConstellationRecipe setCstItem(Fluid fluid, ConstellationAtlarSlot ... slots) {
        return this.setCstItem(fluid, 1000, slots);
    }

    public ConstellationRecipe setCstItem(ItemHandle handle, ConstellationAtlarSlot ... slots) {
        for (ConstellationAtlarSlot slot : slots) {
            this.matchStacks.put(slot, handle);
        }
        return this;
    }

    @Nonnull
    public List<ItemStack> getCstItems(ConstellationAtlarSlot slot) {
        ItemHandle handle = this.matchStacks.get((Object)slot);
        if (handle != null) {
            return handle.getApplicableItems();
        }
        return Lists.newArrayList();
    }

    @Nullable
    public ItemHandle getCstItemHandle(ConstellationAtlarSlot slot) {
        return this.matchStacks.get((Object)slot);
    }

    @Override
    public int craftingTickTime() {
        return 500;
    }

    @Override
    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        for (ConstellationAtlarSlot slot : ConstellationAtlarSlot.values()) {
            ItemStack altarItem;
            ItemHandle expected = this.matchStacks.get((Object)slot);
            if (!(expected != null ? !expected.matchCrafting(altarItem = invHandler.getStackInSlot(slot.slotId)) : invHandler.getStackInSlot(slot.slotId) != null)) continue;
            return false;
        }
        return super.matches(altar, invHandler, ignoreStarlightRequirement);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 altarVec = new Vector3(altar);
            Vector3 thisAltar = altarVec.clone().add(0.5, 0.5, 0.5);
            for (int i = 0; i < 4; ++i) {
                Vector3 dir = offsetPillars[rand.nextInt(offsetPillars.length)].clone();
                dir.multiply(rand.nextFloat()).add(thisAltar.clone());
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(dir.getX(), dir.getY(), dir.getZ());
                particle.setColor(MiscUtils.calcRandomConstellationColor(rand.nextFloat())).scale(0.2f + 0.2f * rand.nextFloat()).gravity(0.004);
            }
        }
    }

    @Override
    @Nonnull
    public ResearchProgression getRequiredProgression() {
        return ResearchProgression.CONSTELLATION;
    }

    public static enum ConstellationAtlarSlot {
        UP_UP_LEFT(13),
        UP_UP_RIGHT(14),
        UP_LEFT_LEFT(15),
        UP_RIGHT_RIGHT(16),
        DOWN_LEFT_LEFT(17),
        DOWN_RIGHT_RIGHT(18),
        DOWN_DOWN_LEFT(19),
        DOWN_DOWN_RIGHT(20);

        private final int slotId;

        private ConstellationAtlarSlot(int slotId) {
            this.slotId = slotId;
        }

        public int getSlotId() {
            return this.slotId;
        }
    }
}

