/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.DiscoveryRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractCacheableRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.ToolCrystalProperties;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalToolBase;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class CrystalToolRecipe
extends DiscoveryRecipe {
    private final ShapedRecipeSlot[] positions;

    public CrystalToolRecipe(AbstractCacheableRecipe recipe, ShapedRecipeSlot ... crystalPositions) {
        super(recipe);
        this.positions = crystalPositions;
    }

    @Override
    public int craftingTickTime() {
        return (int)((double)super.craftingTickTime() * 1.5);
    }

    @Override
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar altar) {
        ItemStack toolOut = super.getOutput(centralGridMap, altar);
        LinkedList<CrystalProperties> prop = new LinkedList<CrystalProperties>();
        for (ShapedRecipeSlot slot : this.positions) {
            ItemStack stack;
            CrystalProperties c;
            ItemHandle handle = (ItemHandle)centralGridMap.get((Object)slot);
            if (handle == null || handle.getApplicableItems().size() != 1 || (c = CrystalProperties.getCrystalProperties(stack = handle.getApplicableItems().get(0))) == null) continue;
            prop.add(c);
        }
        ItemCrystalToolBase.setToolProperties(toolOut, ToolCrystalProperties.merge(prop));
        return toolOut;
    }

    @Override
    @Nonnull
    public ItemStack getOutputForRender() {
        ItemStack stack = super.getOutputForRender();
        LinkedList<CrystalProperties> props = new LinkedList<CrystalProperties>();
        for (int i = 0; i < this.positions.length; ++i) {
            props.add(CrystalProperties.getMaxRockProperties());
        }
        ItemCrystalToolBase.setToolProperties(stack, ToolCrystalProperties.merge(props));
        return stack;
    }

    @Override
    public boolean allowsForChaining() {
        return false;
    }
}

