/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DrawingTableRecipe
extends ConstellationRecipe {
    public DrawingTableRecipe() {
        super(new ShapedRecipe((Block)BlocksAS.drawingTable).addPart(ItemCraftingComponent.MetaType.STARMETAL_INGOT.asStack(), ShapedRecipeSlot.LEFT, ShapedRecipeSlot.RIGHT).addPart(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_RIGHT).addPart(BlockMarble.MarbleBlockType.RUNED.asStack(), ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_CENTER, ShapedRecipeSlot.LOWER_RIGHT));
        this.setAttItem(OreDictAlias.ITEM_DYE_ALL, AttunementRecipe.AttunementAltarSlot.UPPER_LEFT, AttunementRecipe.AttunementAltarSlot.UPPER_RIGHT);
        this.setAttItem(BlockMarble.MarbleBlockType.RUNED.asStack(), AttunementRecipe.AttunementAltarSlot.LOWER_LEFT, AttunementRecipe.AttunementAltarSlot.LOWER_RIGHT);
        this.setCstItem(OreDictAlias.BLOCK_WOOD_LOGS, ConstellationRecipe.ConstellationAtlarSlot.UP_LEFT_LEFT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_LEFT_LEFT, ConstellationRecipe.ConstellationAtlarSlot.UP_RIGHT_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.DOWN_RIGHT_RIGHT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 altarPos = new Vector3(altar);
            for (int i = 0; i < 2; ++i) {
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(altarPos.getX() - 3.0 + (double)(rand.nextFloat() * 7.0f), altarPos.getY(), altarPos.getZ() - 3.0 + (double)(rand.nextFloat() * 7.0f));
                p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.1f);
                p.setColor(new Color(Color.HSBtoRGB(rand.nextFloat() * 360.0f, 1.0f, 1.0f)));
            }
            if (rand.nextInt(10) == 0) {
                Vector3 from = new Vector3(altar).add(0.5, 0.3, 0.5);
                MiscUtils.applyRandomOffset(from, rand, 0.4f);
                EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(4 + rand.nextInt(2)), from, 1.0);
                lightbeam.setMaxAge(64);
                lightbeam.setColorOverlay(new Color(Color.HSBtoRGB(rand.nextFloat() * 360.0f, 1.0f, 1.0f)));
            }
        }
    }
}

