/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.util.ItemColorizationHelper;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.IAccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.ICraftingProgress;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractCacheableRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileAttunementRelay;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TraitRecipe
extends ConstellationRecipe
implements ICraftingProgress {
    public static final BlockPos[] offsetRelays = new BlockPos[]{new BlockPos(0, 0, 3), new BlockPos(2, 0, 2), new BlockPos(3, 0, 0), new BlockPos(2, 0, -2), new BlockPos(0, 0, -3), new BlockPos(-2, 0, -2), new BlockPos(-3, 0, 0), new BlockPos(-2, 0, 2)};
    private List<ItemHandle> additionallyRequiredStacks = Lists.newLinkedList();
    private IConstellation requiredConstellation = null;

    protected TraitRecipe(TileAltar.AltarLevel neededLevel, IAccessibleRecipe recipe) {
        super(neededLevel, recipe);
    }

    protected TraitRecipe(TileAltar.AltarLevel neededLevel, AbstractCacheableRecipe recipe) {
        super(neededLevel, recipe);
    }

    public TraitRecipe(AbstractCacheableRecipe recipe) {
        this(recipe.make());
    }

    public TraitRecipe(IAccessibleRecipe recipe) {
        super(TileAltar.AltarLevel.TRAIT_CRAFT, recipe);
        this.setPassiveStarlightRequirement(8500);
    }

    public TraitRecipe addTraitItem(Item i) {
        return this.addTraitItem(new ItemStack(i));
    }

    public TraitRecipe addTraitItem(Block b) {
        return this.addTraitItem(new ItemStack(b));
    }

    public TraitRecipe addTraitItem(ItemStack stack) {
        return this.addTraitItem(new ItemHandle(stack));
    }

    public TraitRecipe addTraitItem(String oreDict) {
        return this.addTraitItem(new ItemHandle(oreDict));
    }

    public TraitRecipe addTraitItem(FluidStack fluid) {
        return this.addTraitItem(new ItemHandle(fluid));
    }

    public TraitRecipe addTraitItem(Fluid fluid, int mbAmount) {
        return this.addTraitItem(new FluidStack(fluid, mbAmount));
    }

    public TraitRecipe addTraitItem(Fluid fluid) {
        return this.addTraitItem(fluid, 1000);
    }

    public TraitRecipe addTraitItem(ItemHandle handle) {
        this.additionallyRequiredStacks.add(handle);
        return this;
    }

    @Nonnull
    public List<List<ItemStack>> getTraitItems() {
        ArrayList out = Lists.newArrayList();
        for (ItemHandle handle : this.additionallyRequiredStacks) {
            out.add(handle.getApplicableItems());
        }
        return out;
    }

    @Nonnull
    public List<ItemHandle> getTraitItemHandles() {
        return Lists.newArrayList(this.additionallyRequiredStacks);
    }

    public void setRequiredConstellation(IConstellation requiredConstellation) {
        this.requiredConstellation = requiredConstellation;
    }

    @Nullable
    public IConstellation getRequiredConstellation() {
        return this.requiredConstellation;
    }

    @Override
    public int craftingTickTime() {
        return 1000;
    }

    @Override
    public boolean tryProcess(TileAltar altar, ActiveCraftingTask runningTask, NBTTagCompound craftingData, int activeCraftingTick) {
        List<CraftingFocusStack> stacks = this.collectCurrentStacks(craftingData);
        if (!this.matchFocusStacks(altar, stacks)) {
            return false;
        }
        int required = this.additionallyRequiredStacks.size();
        int part = this.craftingTickTime() / 2;
        int offset = this.craftingTickTime() / 10;
        int cttPart = part / required;
        for (int i = 0; i < required; ++i) {
            int timing = i * cttPart + offset;
            if (activeCraftingTick < timing) continue;
            CraftingFocusStack found = null;
            for (CraftingFocusStack stack : stacks) {
                if (stack.stackIndex != i) continue;
                found = stack;
                break;
            }
            if (found != null) continue;
            BlockPos next = this.findUnusedRelay(altar, stacks);
            if (next != null) {
                CraftingFocusStack stack;
                stack = new CraftingFocusStack(i, next);
                stacks.add(stack);
                this.storeCurrentStacks(craftingData, stacks);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        IConstellation focus;
        IConstellation req = this.getRequiredConstellation();
        if (req != null && (focus = altar.getFocusedConstellation()) != null && !req.equals(focus)) {
            return false;
        }
        return super.matches(altar, invHandler, ignoreStarlightRequirement);
    }

    @Override
    @Nonnull
    public ResearchProgression getRequiredProgression() {
        return ResearchProgression.RADIANCE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        ActiveCraftingTask act = altar.getActiveCraftingTask();
        if (act != null) {
            List<CraftingFocusStack> stacks = this.collectCurrentStacks(act.getCraftingData());
            for (CraftingFocusStack stack : stacks) {
                if (stack.stackIndex < 0 || stack.stackIndex >= this.additionallyRequiredStacks.size()) continue;
                ItemHandle required = this.additionallyRequiredStacks.get(stack.stackIndex);
                TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)altar.func_145831_w(), altar.func_174877_v().func_177971_a((Vec3i)stack.offset), TileAttunementRelay.class, true);
                if (tar == null) continue;
                ItemStack found = tar.getInventoryHandler().getStackInSlot(0);
                if (found != null && found.func_77973_b() != null && required.matchCrafting(found)) {
                    Color c = ItemColorizationHelper.getDominantColorFromItemStack(found);
                    if (c == null) {
                        c = BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor;
                    }
                    if (ClientScheduler.getClientTick() % 35L == 0L) {
                        EffectLightbeam beam = EffectHandler.getInstance().lightbeam(new Vector3(tar).add(0.5, 0.1, 0.5), new Vector3(altar).add(0.5, 4.5, 0.5), 0.8);
                        beam.setColorOverlay(c);
                    }
                    if (!rand.nextBoolean()) continue;
                    Vector3 at = new Vector3(tar);
                    at.add((double)rand.nextFloat() * 0.8 + 0.1, 0.0, (double)rand.nextFloat() * 0.8 + 0.1);
                    EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                    p.setAlphaMultiplier(0.7f);
                    p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                    p.gravity(0.01).scale(0.3f + rand.nextFloat() * 0.1f);
                    p.setColor(c);
                    if (rand.nextInt(3) != 0) continue;
                    p.gravity(0.004).scale(0.1f + rand.nextFloat() * 0.1f);
                    p.setColor(Color.WHITE);
                    continue;
                }
                List<ItemStack> stacksApplicable = required.getApplicableItemsForRender();
                if (stacksApplicable.size() <= 0) continue;
                int mod = (int)(ClientScheduler.getClientTick() % (long)(stacksApplicable.size() * 60));
                ItemStack element = stacksApplicable.get(MathHelper.func_76141_d((float)MathHelper.func_76125_a((int)(stacksApplicable.size() * (mod / (stacksApplicable.size() * 60))), (int)0, (int)(stacksApplicable.size() - 1))));
                Color c = ItemColorizationHelper.getDominantColorFromItemStack(element);
                if (c == null) {
                    c = BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor;
                }
                if (ClientScheduler.getClientTick() % 35L == 0L) {
                    EffectLightbeam beam = EffectHandler.getInstance().lightbeam(new Vector3(tar).add(0.5, 0.1, 0.5), new Vector3(altar).add(0.5, 4.5, 0.5), 0.8);
                    beam.setColorOverlay(c);
                }
                if (!rand.nextBoolean()) continue;
                Vector3 at = new Vector3(tar);
                at.add((double)rand.nextFloat() * 0.8 + 0.1, 0.0, (double)rand.nextFloat() * 0.8 + 0.1);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.setAlphaMultiplier(0.7f);
                p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                p.gravity(0.01).scale(0.3f + rand.nextFloat() * 0.1f);
                p.setColor(c);
                if (rand.nextInt(3) != 0) continue;
                p.gravity(0.004).scale(0.1f + rand.nextFloat() * 0.1f);
                p.setColor(Color.WHITE);
            }
        }
    }

    @Nullable
    protected BlockPos findUnusedRelay(TileAltar center, List<CraftingFocusStack> found) {
        LinkedList eligableRelayOffsets = Lists.newLinkedList();
        for (int xx = -3; xx <= 3; ++xx) {
            for (int zz = -3; zz <= 3; ++zz) {
                if (xx == 0 && zz == 0) continue;
                BlockPos offset = new BlockPos(xx, 0, zz);
                TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)center.func_145831_w(), center.func_174877_v().func_177971_a((Vec3i)offset), TileAttunementRelay.class, true);
                if (tar == null) continue;
                eligableRelayOffsets.add(offset);
            }
        }
        for (CraftingFocusStack stack : found) {
            eligableRelayOffsets.remove(stack.offset);
        }
        if (eligableRelayOffsets.size() <= 0) {
            return null;
        }
        return (BlockPos)eligableRelayOffsets.get(center.func_145831_w().field_73012_v.nextInt(eligableRelayOffsets.size()));
    }

    protected boolean matchFocusStacks(TileAltar altar, List<CraftingFocusStack> stacks) {
        for (CraftingFocusStack stack : stacks) {
            int index = stack.stackIndex;
            if (index < 0 || index >= this.additionallyRequiredStacks.size()) continue;
            ItemHandle required = this.additionallyRequiredStacks.get(index);
            TileAttunementRelay relay = MiscUtils.getTileAt((IBlockAccess)altar.func_145831_w(), altar.func_174877_v().func_177971_a((Vec3i)stack.offset), TileAttunementRelay.class, true);
            if (relay == null) {
                return false;
            }
            ItemStack in = relay.getInventoryHandler().getStackInSlot(0);
            if (in != null && in.func_77973_b() != null && required.matchCrafting(in)) continue;
            return false;
        }
        return true;
    }

    protected void storeCurrentStacks(NBTTagCompound craftingStorage, List<CraftingFocusStack> stacks) {
        NBTTagList list = new NBTTagList();
        for (CraftingFocusStack stack : stacks) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("focusIndex", stack.stackIndex.intValue());
            NBTUtils.writeBlockPosToNBT(stack.offset, tag);
            list.func_74742_a((NBTBase)tag);
        }
        craftingStorage.func_74782_a("offsetFocusList", (NBTBase)list);
    }

    protected List<CraftingFocusStack> collectCurrentStacks(NBTTagCompound craftingStorage) {
        LinkedList stacks = Lists.newLinkedList();
        NBTTagList list = craftingStorage.func_150295_c("offsetFocusList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound cmp = list.func_150305_b(i);
            int index = cmp.func_74762_e("focusIndex");
            BlockPos pos = NBTUtils.readBlockPosFromNBT(cmp);
            stacks.add(new CraftingFocusStack(index, pos));
        }
        return stacks;
    }

    protected static class CraftingFocusStack {
        protected final Integer stackIndex;
        protected final BlockPos offset;

        protected CraftingFocusStack(Integer stackIndex, BlockPos offset) {
            this.stackIndex = stackIndex;
            this.offset = offset;
        }
    }
}

