/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHelper {
    public static IRecipe getShapelessOreDictRecipe(ItemStack stack, Object ... recipeComponents) {
        return new ShapelessHandleOreRecipe(stack, recipeComponents);
    }

    public static IRecipe getShapedOredictRecipe(ItemStack stack, Object ... recipeComponents) {
        return new ShapedHandleOreRecipe(stack, recipeComponents);
    }

    public static class ShapedHandleOreRecipe
    extends ShapedOreRecipe {
        public static final int MAX_CRAFT_GRID_WIDTH = 3;
        public static final int MAX_CRAFT_GRID_HEIGHT = 3;

        public ShapedHandleOreRecipe(Block result, Object ... recipe) {
            this(new ItemStack(result), recipe);
        }

        public ShapedHandleOreRecipe(Item result, Object ... recipe) {
            this(new ItemStack(result), recipe);
        }

        public ShapedHandleOreRecipe(ItemStack result, Object ... recipe) {
            super(result.func_77946_l(), new Object[]{"R", Character.valueOf('R'), new ItemStack(Blocks.field_150348_b)});
            this.output = null;
            this.input = null;
            this.height = 0;
            this.width = 0;
            this.mirrored = true;
            this.output = result.func_77946_l();
            String shape = "";
            int idx = 0;
            if (recipe[idx] instanceof Boolean) {
                this.mirrored = (Boolean)recipe[idx];
                if (recipe[idx + 1] instanceof Object[]) {
                    recipe = (Object[])recipe[idx + 1];
                } else {
                    idx = 1;
                }
            }
            if (recipe[idx] instanceof String[]) {
                String[] parts = (String[])recipe[idx++];
                for (String s : parts) {
                    this.width = s.length();
                    shape = shape + (String)s;
                }
                this.height = parts.length;
            } else {
                while (recipe[idx] instanceof String) {
                    String s = (String)recipe[idx++];
                    shape = shape + s;
                    this.width = s.length();
                    ++this.height;
                }
            }
            if (this.width * this.height != shape.length()) {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
            while (idx < recipe.length) {
                Character chr = (Character)recipe[idx];
                Object in = recipe[idx + 1];
                if (in instanceof ItemStack) {
                    itemMap.put(chr, ((ItemStack)in).func_77946_l());
                } else if (in instanceof Item) {
                    itemMap.put(chr, new ItemStack((Item)in));
                } else if (in instanceof Block) {
                    itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
                } else if (in instanceof String) {
                    itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
                } else if (in instanceof List) {
                    itemMap.put(chr, in);
                } else {
                    String ret = "Invalid shaped ore recipe: ";
                    for (Object tmp : recipe) {
                        ret = ret + tmp + ", ";
                    }
                    ret = ret + this.output;
                    throw new RuntimeException(ret);
                }
                idx += 2;
            }
            this.input = new Object[this.width * this.height];
            int x = 0;
            for (char chr : shape.toCharArray()) {
                this.input[x++] = itemMap.get(Character.valueOf(chr));
            }
        }

        ShapedHandleOreRecipe(ShapedRecipes recipe, Map<ItemStack, String> replacements) {
            super(recipe.func_77571_b(), new Object[0]);
            this.output = recipe.func_77571_b();
            this.width = recipe.field_77576_b;
            this.height = recipe.field_77577_c;
            this.input = new Object[recipe.field_77574_d.length];
            block0: for (int i = 0; i < this.input.length; ++i) {
                ItemStack ingredient = recipe.field_77574_d[i];
                if (ingredient == null) continue;
                this.input[i] = recipe.field_77574_d[i];
                for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                    if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingredient, (boolean)true)) continue;
                    this.input[i] = OreDictionary.getOres((String)replace.getValue());
                    continue block0;
                }
            }
        }

        public ItemStack func_77572_b(InventoryCrafting var1) {
            return this.output.func_77946_l();
        }

        public int func_77570_a() {
            return this.input.length;
        }

        public ItemStack func_77571_b() {
            return this.output;
        }

        public boolean func_77569_a(InventoryCrafting inv, World world) {
            for (int x = 0; x <= 3 - this.width; ++x) {
                for (int y = 0; y <= 3 - this.height; ++y) {
                    if (this.checkMatch(inv, x, y, false)) {
                        return true;
                    }
                    if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    int subX = x - startX;
                    int subY = y - startY;
                    Object target = null;
                    if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                        target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                    }
                    ItemStack slot = inv.func_70463_b(x, y);
                    if (target instanceof ItemStack) {
                        if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                        return false;
                    }
                    if (target instanceof List) {
                        boolean matched = false;
                        Iterator itr = ((List)target).iterator();
                        while (itr.hasNext() && !matched) {
                            matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                        }
                        if (matched) continue;
                        return false;
                    }
                    if (target != null || slot == null) continue;
                    return false;
                }
            }
            return true;
        }

        public ShapedHandleOreRecipe setMirrored(boolean mirror) {
            this.mirrored = mirror;
            return this;
        }

        public Object[] getInput() {
            return this.input;
        }

        public ItemStack[] func_179532_b(InventoryCrafting inv) {
            return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        }
    }

    public static class ShapelessHandleOreRecipe
    extends ShapelessOreRecipe {
        protected ItemStack output = null;
        protected ArrayList<Object> input = new ArrayList();

        public ShapelessHandleOreRecipe(Block result, Object ... recipe) {
            this(new ItemStack(result), recipe);
        }

        public ShapelessHandleOreRecipe(Item result, Object ... recipe) {
            this(new ItemStack(result), recipe);
        }

        public ShapelessHandleOreRecipe(ItemStack result, Object ... recipe) {
            super(result.func_77946_l(), new Object[0]);
            this.output = result.func_77946_l();
            for (Object in : recipe) {
                if (in instanceof ItemStack) {
                    this.input.add(((ItemStack)in).func_77946_l());
                    continue;
                }
                if (in instanceof Item) {
                    this.input.add(new ItemStack((Item)in));
                    continue;
                }
                if (in instanceof Block) {
                    this.input.add(new ItemStack((Block)in));
                    continue;
                }
                if (in instanceof String) {
                    this.input.add(OreDictionary.getOres((String)((String)in)));
                    continue;
                }
                if (in instanceof List) {
                    this.input.add(in);
                    continue;
                }
                String ret = "Invalid shapeless ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
        }

        ShapelessHandleOreRecipe(ShapelessRecipes recipe, Map<ItemStack, String> replacements) {
            super(recipe.func_77571_b(), new Object[0]);
            this.output = recipe.func_77571_b();
            Iterator iterator = recipe.field_77579_b.iterator();
            while (iterator.hasNext()) {
                ItemStack ingredient;
                Object finalObj = ingredient = (ItemStack)iterator.next();
                for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                    if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingredient, (boolean)false)) continue;
                    finalObj = OreDictionary.getOres((String)replace.getValue());
                    break;
                }
                this.input.add(finalObj);
            }
        }

        public int func_77570_a() {
            return this.input.size();
        }

        public ItemStack func_77571_b() {
            return this.output;
        }

        public ItemStack func_77572_b(InventoryCrafting var1) {
            return this.output.func_77946_l();
        }

        public boolean func_77569_a(InventoryCrafting var1, World world) {
            ArrayList<Object> required = new ArrayList<Object>(this.input);
            for (int x = 0; x < var1.func_70302_i_(); ++x) {
                ItemStack slot = var1.func_70301_a(x);
                if (slot == null) continue;
                boolean inRecipe = false;
                Iterator<Object> req = required.iterator();
                while (req.hasNext()) {
                    boolean match = false;
                    Object next = req.next();
                    if (next instanceof ItemStack) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                    } else if (next instanceof List) {
                        Iterator itr = ((List)next).iterator();
                        while (itr.hasNext() && !match) {
                            match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                        }
                    }
                    if (!match) continue;
                    inRecipe = true;
                    required.remove(next);
                    break;
                }
                if (inRecipe) continue;
                return false;
            }
            return required.isEmpty();
        }

        public ArrayList<Object> getInput() {
            return this.input;
        }

        public ItemStack[] func_179532_b(InventoryCrafting inv) {
            return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        }
    }
}

