/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.ShapedLightProximityRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractCacheableRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.RecipeHelper;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ShapedRecipe
extends AbstractCacheableRecipe {
    protected ShapeMap crafingShape = new ShapeMap();
    private boolean forceEmptySpaces = false;

    public ShapedRecipe(Block output) {
        this(new ItemStack(output));
    }

    public ShapedRecipe(Item output) {
        this(new ItemStack(output));
    }

    public ShapedRecipe(ItemStack output) {
        super(output);
    }

    public ShapedRecipe addPart(Block block, ShapedRecipeSlot ... slots) {
        return this.addPart(new ItemStack(block), slots);
    }

    public ShapedRecipe addPart(Item stack, ShapedRecipeSlot ... slots) {
        return this.addPart(new ItemStack(stack), slots);
    }

    public ShapedRecipe addPart(ItemStack stack, ShapedRecipeSlot ... slots) {
        ItemHandle handle = new ItemHandle(stack);
        for (ShapedRecipeSlot slot : slots) {
            this.crafingShape.put(slot, handle);
        }
        return this;
    }

    public ShapedRecipe addPart(FluidStack fluidStack, ShapedRecipeSlot ... slots) {
        ItemHandle handle = new ItemHandle(fluidStack);
        for (ShapedRecipeSlot slot : slots) {
            this.crafingShape.put(slot, handle);
        }
        return this;
    }

    public ShapedRecipe addPart(Fluid fluid, int mbAmount, ShapedRecipeSlot ... slots) {
        return this.addPart(new FluidStack(fluid, mbAmount), slots);
    }

    public ShapedRecipe addPart(Fluid fluid, ShapedRecipeSlot ... slots) {
        return this.addPart(fluid, 1000, slots);
    }

    public ShapedRecipe addPart(String oreDictName, ShapedRecipeSlot ... slots) {
        ItemHandle handle = new ItemHandle(oreDictName);
        for (ShapedRecipeSlot slot : slots) {
            this.crafingShape.put(slot, handle);
        }
        return this;
    }

    public ShapedRecipe addPart(ItemHandle handle, ShapedRecipeSlot ... slots) {
        for (ShapedRecipeSlot slot : slots) {
            this.crafingShape.put(slot, handle);
        }
        return this;
    }

    public ShapedRecipe forceEmptySpaces() {
        this.forceEmptySpaces = true;
        return this;
    }

    @Override
    public void register() {
        CraftingManager.func_77594_a().func_180302_a((IRecipe)this.make());
    }

    @Override
    public AccessibleRecipeAdapater make() {
        return new AccessibleRecipeAdapater(RecipeHelper.getShapedOredictRecipe(this.getOutput(), this.getNativeObjOutArray()), this);
    }

    @Override
    public IRecipe makeNative() {
        return RecipeHelper.getShapedOredictRecipe(this.getOutput(), this.getNativeObjOutArray());
    }

    public ShapedLightProximityRecipe makeLightProximityRecipe() {
        return new ShapedLightProximityRecipe(this.getOutput(), this.getNativeObjOutArray());
    }

    private Object[] getNativeObjOutArray() {
        Counter c = new Counter();
        c.count = 0;
        HashMap<ItemHandle, Character> shapeCharacters = new HashMap<ItemHandle, Character>();
        String upperRow = this.refactorRow(ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_CENTER, ShapedRecipeSlot.UPPER_RIGHT, shapeCharacters, c);
        String middleRow = this.refactorRow(ShapedRecipeSlot.LEFT, ShapedRecipeSlot.CENTER, ShapedRecipeSlot.RIGHT, shapeCharacters, c);
        String lowerRow = this.refactorRow(ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_CENTER, ShapedRecipeSlot.LOWER_RIGHT, shapeCharacters, c);
        if (this.forceEmptySpaces) {
            int arrayLength = 3 + shapeCharacters.size() * 2;
            Object[] recipeObjArray = new Object[arrayLength];
            recipeObjArray[0] = upperRow;
            recipeObjArray[1] = middleRow;
            recipeObjArray[2] = lowerRow;
            int arrayPointer = 3;
            this.addToArray(shapeCharacters, recipeObjArray, arrayPointer);
            return recipeObjArray;
        }
        String[] recipeTrimmed = this.trimRecipeStrings(upperRow, middleRow, lowerRow);
        int point = 0;
        if (!recipeTrimmed[0].trim().isEmpty()) {
            ++point;
        }
        if (!recipeTrimmed[1].trim().isEmpty()) {
            ++point;
        }
        if (!recipeTrimmed[2].trim().isEmpty()) {
            ++point;
        }
        int arrayLength = point + shapeCharacters.size() * 2;
        Object[] recipeObjArray = new Object[arrayLength];
        int pointer = 0;
        if (!recipeTrimmed[0].trim().isEmpty()) {
            recipeObjArray[pointer] = recipeTrimmed[0];
            ++pointer;
        }
        if (!recipeTrimmed[1].trim().isEmpty()) {
            recipeObjArray[pointer] = recipeTrimmed[1];
            ++pointer;
        }
        if (!recipeTrimmed[2].trim().isEmpty()) {
            recipeObjArray[pointer] = recipeTrimmed[2];
        }
        this.addToArray(shapeCharacters, recipeObjArray, point);
        return recipeObjArray;
    }

    private String[] trimRecipeStrings(String upperRow, String middleRow, String lowerRow) {
        String[] out = new String[]{upperRow, middleRow, lowerRow};
        ArrayList<Integer> cutIndices = new ArrayList<Integer>(3);
        for (int i = 0; i < 3; ++i) {
            boolean mayRemove = true;
            for (int j = 0; j < 3; ++j) {
                String str = out[j];
                if (str.charAt(i) == ' ') continue;
                mayRemove = false;
            }
            if (!mayRemove) continue;
            cutIndices.add(i);
        }
        for (int j = 0; j < 3; ++j) {
            out[j] = new String(this.cut(out[j].toCharArray(), cutIndices));
        }
        return out;
    }

    private char[] cut(char[] in, List<Integer> toRemove) {
        char[] out = new char[in.length - toRemove.size()];
        int outPointer = 0;
        for (int i = 0; i < in.length; ++i) {
            if (toRemove.contains(i)) continue;
            out[outPointer] = in[i];
            ++outPointer;
        }
        return out;
    }

    @Override
    @Nullable
    public ItemHandle getExpectedStack(int row, int column) {
        ShapedRecipeSlot slot = ShapedRecipeSlot.getByRowColumnIndex(row, column);
        return slot == null ? null : (ItemHandle)this.crafingShape.get((Object)slot);
    }

    @Override
    @Nullable
    public ItemHandle getExpectedStack(ShapedRecipeSlot slot) {
        return (ItemHandle)this.crafingShape.get((Object)slot);
    }

    private void addToArray(Map<ItemHandle, Character> shapeCharacters, Object[] recipeObjArray, int arrayPointer) {
        for (ItemHandle key : shapeCharacters.keySet()) {
            Character value = shapeCharacters.get(key);
            recipeObjArray[arrayPointer] = value;
            recipeObjArray[++arrayPointer] = key.getObjectForRecipe();
            ++arrayPointer;
        }
    }

    private String refactorRow(ShapedRecipeSlot first, ShapedRecipeSlot second, ShapedRecipeSlot third, Map<ItemHandle, Character> characterMap, Counter craftingPointer) {
        StringBuilder builder = new StringBuilder();
        if (this.append(first, builder, craftingPointer, characterMap)) {
            ++craftingPointer.count;
        }
        if (this.append(second, builder, craftingPointer, characterMap)) {
            ++craftingPointer.count;
        }
        if (this.append(third, builder, craftingPointer, characterMap)) {
            ++craftingPointer.count;
        }
        return builder.toString();
    }

    private boolean append(ShapedRecipeSlot slot, StringBuilder builder, Counter craftingPointer, Map<ItemHandle, Character> characterMap) {
        boolean increment = false;
        if (this.crafingShape.get((Object)slot) != null) {
            Character toAdd;
            ItemHandle firstStack = (ItemHandle)this.crafingShape.get((Object)slot);
            if (characterMap.containsKey(firstStack)) {
                toAdd = characterMap.get(firstStack);
            } else {
                toAdd = this.refactorCraftingPointer(craftingPointer.count);
                characterMap.put(firstStack, toAdd);
                increment = true;
            }
            builder.append(toAdd);
        } else {
            builder.append(" ");
        }
        return increment;
    }

    private Character refactorCraftingPointer(int pointer) {
        switch (pointer) {
            case 0: {
                return Character.valueOf('A');
            }
            case 1: {
                return Character.valueOf('B');
            }
            case 2: {
                return Character.valueOf('C');
            }
            case 3: {
                return Character.valueOf('D');
            }
            case 4: {
                return Character.valueOf('E');
            }
            case 5: {
                return Character.valueOf('F');
            }
            case 6: {
                return Character.valueOf('G');
            }
            case 7: {
                return Character.valueOf('H');
            }
            case 8: {
                return Character.valueOf('I');
            }
        }
        return null;
    }

    private class Counter {
        int count;

        private Counter() {
        }
    }
}

