/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractCacheableRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.RecipeHelper;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ShapelessRecipe
extends AbstractCacheableRecipe {
    protected int contentCounter = 0;
    protected ItemHandle[] contents = new ItemHandle[9];

    public ShapelessRecipe(Block block) {
        this(new ItemStack(block));
    }

    public ShapelessRecipe(Item item) {
        this(new ItemStack(item));
    }

    public ShapelessRecipe(ItemStack output) {
        super(output);
    }

    public ShapelessRecipe add(Block block) {
        return this.add(new ItemStack(block));
    }

    public ShapelessRecipe add(Item item) {
        return this.add(new ItemStack(item));
    }

    public ShapelessRecipe add(ItemStack stack) {
        if (this.contentCounter >= 9) {
            return this;
        }
        this.contents[this.contentCounter++] = new ItemHandle(stack);
        return this;
    }

    public ShapelessRecipe add(String oreDictName) {
        if (this.contentCounter >= 9) {
            return this;
        }
        this.contents[this.contentCounter++] = new ItemHandle(oreDictName);
        return this;
    }

    public ShapelessRecipe addPart(FluidStack fluidStack) {
        if (this.contentCounter >= 9) {
            return this;
        }
        this.contents[this.contentCounter++] = new ItemHandle(fluidStack);
        return this;
    }

    public ShapelessRecipe addPart(Fluid fluid, int mbAmount) {
        return this.addPart(new FluidStack(fluid, mbAmount));
    }

    public ShapelessRecipe addPart(Fluid fluid) {
        return this.addPart(fluid, 1000);
    }

    public ShapelessRecipe addPart(ItemHandle handle) {
        if (this.contentCounter >= 9) {
            return this;
        }
        this.contents[this.contentCounter++] = handle;
        return this;
    }

    @Override
    public void register() {
        CraftingManager.func_77594_a().func_180302_a((IRecipe)this.make());
    }

    @Override
    public AccessibleRecipeAdapater make() {
        Object[] parts = new Object[this.contentCounter];
        for (int i = 0; i < parts.length; ++i) {
            Object obj = parts[i];
            parts[i] = obj instanceof ItemHandle ? this.contents[i].getObjectForRecipe() : this.contents[i];
        }
        return new AccessibleRecipeAdapater(RecipeHelper.getShapelessOreDictRecipe(this.getOutput(), parts), this);
    }

    @Override
    public IRecipe makeNative() {
        Object[] parts = new Object[this.contentCounter];
        for (int i = 0; i < parts.length; ++i) {
            Object obj = parts[i];
            parts[i] = obj instanceof ItemHandle ? this.contents[i].getObjectForRecipe() : this.contents[i];
        }
        return RecipeHelper.getShapelessOreDictRecipe(this.getOutput(), parts);
    }

    @Override
    @Nullable
    public ItemHandle getExpectedStack(int row, int column) {
        int index = row * 3 + column;
        return index >= this.contentCounter ? null : this.contents[index];
    }

    @Override
    @Nullable
    public ItemHandle getExpectedStack(ShapedRecipeSlot slot) {
        int index = slot.rowMultipler * 3 + slot.columnMultiplier;
        return index >= this.contentCounter ? null : this.contents[index];
    }
}

