/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.infusion;

import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ActiveInfusionTask {
    private final AbstractInfusionRecipe recipeToCraft;
    private final UUID playerCraftingUUID;
    private int ticksCrafting = 0;

    public ActiveInfusionTask(AbstractInfusionRecipe recipeToCraft, UUID playerCraftingUUID) {
        this.recipeToCraft = recipeToCraft;
        this.playerCraftingUUID = playerCraftingUUID;
    }

    public UUID getPlayerCraftingUUID() {
        return this.playerCraftingUUID;
    }

    @Nullable
    public EntityPlayer tryGetCraftingPlayerServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerCraftingUUID);
    }

    public void tick(TileStarlightInfuser infuser) {
        ++this.ticksCrafting;
    }

    public int getTicksCrafting() {
        return this.ticksCrafting;
    }

    public AbstractInfusionRecipe getRecipeToCraft() {
        return this.recipeToCraft;
    }

    public boolean isFinished() {
        return this.ticksCrafting >= this.recipeToCraft.craftingTickTime();
    }

    public void forceTick(int tick) {
        this.ticksCrafting = tick;
    }
}

