/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.infusion;

import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.crafting.infusion.AbstractInfusionRecipe;
import hellfirepvp.astralsorcery.common.crafting.infusion.recipes.BasicInfusionRecipe;
import hellfirepvp.astralsorcery.common.crafting.infusion.recipes.LowConsumptionInfusionRecipe;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class InfusionRecipeRegistry {
    public static List<AbstractInfusionRecipe> mtRecipes = new LinkedList<AbstractInfusionRecipe>();
    public static List<AbstractInfusionRecipe> recipes = new LinkedList<AbstractInfusionRecipe>();
    private static AbstractInfusionRecipe[] compiledRecipes = null;
    private static List<AbstractInfusionRecipe> localFallbackCache = new LinkedList<AbstractInfusionRecipe>();

    public static void compileRecipes() {
        AbstractInfusionRecipe rec;
        compiledRecipes = null;
        int totalNeeded = recipes.size() + mtRecipes.size();
        int i = 0;
        compiledRecipes = new AbstractInfusionRecipe[totalNeeded];
        Iterator<AbstractInfusionRecipe> iterator = recipes.iterator();
        while (iterator.hasNext()) {
            InfusionRecipeRegistry.compiledRecipes[i] = rec = iterator.next();
            rec.updateUniqueId(i);
            ++i;
        }
        iterator = mtRecipes.iterator();
        while (iterator.hasNext()) {
            InfusionRecipeRegistry.compiledRecipes[i] = rec = iterator.next();
            rec.updateUniqueId(i);
            ++i;
        }
    }

    public static void cacheLocalRecipes() {
        if (localFallbackCache.isEmpty()) {
            localFallbackCache.addAll(recipes);
        }
    }

    public static void loadFromFallback() {
        if (!localFallbackCache.isEmpty()) {
            recipes.addAll(localFallbackCache);
        }
    }

    @Nullable
    public static AbstractInfusionRecipe getRecipe(int id) {
        if (id < 0 || id >= compiledRecipes.length) {
            return null;
        }
        return compiledRecipes[id];
    }

    @Nullable
    public static AbstractInfusionRecipe removeFindRecipeByOutput(ItemStack output) {
        ItemStack out;
        AbstractInfusionRecipe recipe;
        Iterator<AbstractInfusionRecipe> iterator = recipes.iterator();
        while (iterator.hasNext()) {
            recipe = iterator.next();
            out = recipe.getOutputForMatching();
            if (out == null || !ItemUtils.matchStackLoosely(recipe.getOutputForMatching(), output)) continue;
            iterator.remove();
            return recipe;
        }
        iterator = mtRecipes.iterator();
        while (iterator.hasNext()) {
            recipe = iterator.next();
            out = recipe.getOutputForMatching();
            if (out == null || !ItemUtils.matchStackLoosely(recipe.getOutputForMatching(), output)) continue;
            iterator.remove();
            return recipe;
        }
        return null;
    }

    public static BasicInfusionRecipe registerBasicInfusion(ItemStack output, ItemStack input) {
        return InfusionRecipeRegistry.registerInfusionRecipe(new BasicInfusionRecipe(output, input));
    }

    public static LowConsumptionInfusionRecipe registerLowConsumptionInfusion(ItemStack output, ItemStack input) {
        return InfusionRecipeRegistry.registerInfusionRecipe(new LowConsumptionInfusionRecipe(output, input));
    }

    public static <T extends AbstractInfusionRecipe> T registerInfusionRecipe(T recipe) {
        recipes.add(recipe);
        if (CraftingAccessManager.hasCompletedSetup()) {
            CraftingAccessManager.compile();
        }
        return recipe;
    }

    @Nullable
    public static AbstractInfusionRecipe findMatchingRecipe(TileStarlightInfuser ti) {
        for (AbstractInfusionRecipe rec : recipes) {
            if (!rec.matches(ti)) continue;
            return rec;
        }
        for (AbstractInfusionRecipe rec : mtRecipes) {
            if (!rec.matches(ti)) continue;
            return rec;
        }
        return null;
    }
}

