/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data;

import hellfirepvp.astralsorcery.common.data.AbstractData;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DataWorldSkyHandlers
extends AbstractData {
    private List<Integer> activeWorldSkyHandlers = new LinkedList<Integer>();

    public boolean hasWorldHandler(World world) {
        return world != null && this.hasWorldHandler(world.field_73011_w.getDimension());
    }

    public boolean hasWorldHandler(int dim) {
        return this.activeWorldSkyHandlers.contains(dim);
    }

    public static boolean hasWorldHandler(int dim, Side side) {
        DataWorldSkyHandlers handle = (DataWorldSkyHandlers)SyncDataHolder.getData(side, "ActiveWorldSkyHandlers");
        return handle.hasWorldHandler(dim);
    }

    public static boolean hasWorldHandler(World world, Side side) {
        DataWorldSkyHandlers handle = (DataWorldSkyHandlers)SyncDataHolder.getData(side, "ActiveWorldSkyHandlers");
        return handle.hasWorldHandler(world);
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        NBTTagList dims = new NBTTagList();
        for (Integer i : this.activeWorldSkyHandlers) {
            dims.func_74742_a((NBTBase)new NBTTagInt(i.intValue()));
        }
        compound.func_74782_a("dims", (NBTBase)dims);
    }

    @Override
    public void writeToPacket(NBTTagCompound compound) {
        this.writeAllDataToPacket(compound);
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        this.activeWorldSkyHandlers.clear();
        NBTTagList dims = compound.func_150295_c("dims", 3);
        for (int i = 0; i < dims.func_74745_c(); ++i) {
            this.activeWorldSkyHandlers.add(dims.func_186858_c(i));
        }
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        if (!(serverData instanceof DataWorldSkyHandlers)) {
            return;
        }
        this.activeWorldSkyHandlers = ((DataWorldSkyHandlers)serverData).activeWorldSkyHandlers;
    }

    public void update(List<Integer> newDimIds) {
        this.activeWorldSkyHandlers = new LinkedList<Integer>(newDimIds);
        this.markDirty();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClient(List<Integer> dimIds) {
        this.activeWorldSkyHandlers = new LinkedList<Integer>(dimIds);
    }

    public void clientClean() {
        this.activeWorldSkyHandlers = new LinkedList<Integer>();
    }

    public List<Integer> getSkyHandlerDimensions() {
        return Collections.unmodifiableList(this.activeWorldSkyHandlers);
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataWorldSkyHandlers> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataWorldSkyHandlers provideNewInstance() {
            return new DataWorldSkyHandlers();
        }
    }
}

