/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.server;

import hellfirepvp.astralsorcery.common.data.DataWorldSkyHandlers;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.config.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;

public class ServerData {
    public static List<Integer> fileRequestedDimWhitelists = new ArrayList<Integer>();

    @Nullable
    public static File getServerDataFile() {
        ISaveHandler handler;
        try {
            handler = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G();
        }
        catch (Exception exc) {
            return null;
        }
        return ServerData.getServerDataFile(handler);
    }

    @Nullable
    public static File getServerDataFile(ISaveHandler handler) {
        File worldDir;
        try {
            worldDir = handler.func_75765_b();
        }
        catch (Exception exc) {
            return null;
        }
        File f = new File(worldDir, "AstralSorcery_ServerData.dat");
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    public static void reloadDataFromSaveHandler(ISaveHandler handler) {
        ServerData.loadDataFromFile(handler);
        ServerData.updateData(handler);
    }

    public static void writeData() {
        ServerData.updateData(null);
        fileRequestedDimWhitelists.clear();
    }

    public static void addDimensionToHandle(int dimId) {
        if (!fileRequestedDimWhitelists.contains(dimId)) {
            fileRequestedDimWhitelists.add(dimId);
            ServerData.updateData(null);
        }
    }

    public static boolean isDimensionWhitelisted(int dimId) {
        for (Integer i : fileRequestedDimWhitelists) {
            if (i != dimId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateData(@Nullable ISaveHandler handler) {
        File dataFile;
        File file = dataFile = handler == null ? ServerData.getServerDataFile() : ServerData.getServerDataFile(handler);
        if (dataFile == null) {
            FMLLog.bigWarning((String)"[AstralSorcery] Couldn't find folder for AstralSorcery_ServerData.dat - Are you calling this too early or too late in the execution?", (Object[])new Object[0]);
            return;
        }
        try {
            dataFile.delete();
            dataFile.createNewFile();
            NBTTagCompound out = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            LinkedList<Integer> collect = new LinkedList<Integer>();
            collect.addAll(fileRequestedDimWhitelists);
            for (Integer configDim : Config.constellationSkyDimWhitelist) {
                if (collect.contains(configDim)) continue;
                collect.add(configDim);
            }
            for (Integer dimId : collect) {
                list.func_74742_a((NBTBase)new NBTTagInt(dimId.intValue()));
            }
            out.func_74782_a("dimWhitelist", (NBTBase)list);
            CompressedStreamTools.func_74795_b((NBTTagCompound)out, (File)dataFile);
        }
        catch (IOException e) {
            FMLLog.bigWarning((String)"[AstralSorcery] Couldn't write ServerData File (AstralSorcery_ServerData.dat) - Expect issues.", (Object[])new Object[0]);
        }
        finally {
            ServerData.pushData(fileRequestedDimWhitelists);
        }
    }

    private static void pushData(List<Integer> fileRequestedDimWhitelists) {
        DataWorldSkyHandlers skyHandlers = (DataWorldSkyHandlers)SyncDataHolder.getDataServer("ActiveWorldSkyHandlers");
        skyHandlers.update(fileRequestedDimWhitelists);
    }

    private static void loadDataFromFile(@Nullable ISaveHandler handler) {
        File dataFile;
        File file = dataFile = handler == null ? ServerData.getServerDataFile() : ServerData.getServerDataFile(handler);
        if (dataFile == null) {
            FMLLog.bigWarning((String)"[AstralSorcery] Couldn't find folder for AstralSorcery_ServerData.dat - Are you calling this too early or too late in the execution?", (Object[])new Object[0]);
            return;
        }
        try {
            NBTTagCompound cmp = CompressedStreamTools.func_74797_a((File)dataFile);
            NBTTagList dimIds = cmp.func_150295_c("dimWhitelist", 3);
            for (int i = 0; i < dimIds.func_74745_c(); ++i) {
                fileRequestedDimWhitelists.add(dimIds.func_186858_c(i));
            }
            for (Integer configDim : Config.constellationSkyDimWhitelist) {
                if (fileRequestedDimWhitelists.contains(configDim)) continue;
                fileRequestedDimWhitelists.add(configDim);
            }
        }
        catch (IOException e) {
            FMLLog.bigWarning((String)"[AstralSorcery] Couldn't read ServerData File (AstralSorcery_ServerData.dat) - Expect issues.", (Object[])new Object[0]);
            ServerData.defaultToConfig();
        }
    }

    private static void defaultToConfig() {
        fileRequestedDimWhitelists = Arrays.asList(Config.constellationSkyDimWhitelist);
    }
}

