/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world.data;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GatewayCache
extends CachedWorldData {
    private List<BlockPos> gatewayPositions = new LinkedList<BlockPos>();

    public GatewayCache() {
        super(WorldCacheManager.SaveKey.GATEWAY_DATA);
    }

    public List<BlockPos> getGatewayPositions() {
        return new ArrayList<BlockPos>(this.gatewayPositions);
    }

    public void offerPosition(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileCelestialGateway)) {
            return;
        }
        if (this.gatewayPositions.contains(pos)) {
            return;
        }
        this.gatewayPositions.add(pos);
        this.markDirty();
        CelestialGatewaySystem.instance.addPosition(world, pos);
        AstralSorcery.log.info("Added new gateway node at: dim=" + world.field_73011_w.getDimension() + ", " + pos.toString());
    }

    public void removePosition(World world, BlockPos pos) {
        if (this.gatewayPositions.remove(pos)) {
            this.markDirty();
            CelestialGatewaySystem.instance.removePosition(world, pos);
            AstralSorcery.log.info("Removed gateway node at: dim=" + world.field_73011_w.getDimension() + ", " + pos.toString());
        }
    }

    @Override
    public void onLoad(World world) {
        AstralSorcery.log.info("Checking GatewayCache integrity for dimension " + world.field_73011_w.getDimension());
        long msStart = System.currentTimeMillis();
        Iterator<BlockPos> iterator = this.gatewayPositions.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof TileCelestialGateway) continue;
            iterator.remove();
            AstralSorcery.log.info("Invalid entry: " + pos + " - no gateway tileentity found there!");
        }
        AstralSorcery.log.info("GatewayCache checked and fully loaded in " + (System.currentTimeMillis() - msStart) + "ms! Collected and checked " + this.gatewayPositions.size() + " gateway nodes!");
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("posList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.gatewayPositions.add(NBTUtils.readBlockPosFromNBT(list.func_150305_b(i)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (BlockPos pos : this.gatewayPositions) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTUtils.writeBlockPosToNBT(pos, tag);
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("posList", (NBTBase)list);
    }

    @Override
    public void updateTick(World world) {
    }
}

