/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.entities.EntityItemHighlighted;
import hellfirepvp.astralsorcery.common.entities.EntityStarlightReacttant;
import hellfirepvp.astralsorcery.common.item.base.ItemHighlighted;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemTunedCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemRockCrystalBase;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCrystal
extends EntityItemHighlighted
implements EntityStarlightReacttant {
    private static final AxisAlignedBB boxCraft = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final int TOTAL_MERGE_TIME = 1200;
    private int inertMergeTick = 0;

    public EntityCrystal(World worldIn) {
        super(worldIn);
    }

    public EntityCrystal(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityCrystal(World worldIn, double x, double y, double z, ItemStack stack) {
        super(worldIn, x, y, z, stack);
        Item i = stack.func_77973_b();
        if (i != null && i instanceof ItemHighlighted) {
            this.applyColor(((ItemHighlighted)i).getHightlightColor(stack));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70292_b + 5 >= this.lifespan) {
            this.field_70292_b = 0;
        }
        if (Config.craftingLiqCrystalGrowth) {
            this.checkIncreaseConditions();
        }
    }

    private void checkIncreaseConditions() {
        if (this.field_70170_p.field_72995_K) {
            if (this.canCraft()) {
                this.spawnCraftingParticles();
            }
        } else {
            if (CrystalProperties.getCrystalProperties(this.func_92059_d()) == null) {
                this.func_70106_y();
            }
            if (this.canCraft()) {
                ++this.inertMergeTick;
                if (this.inertMergeTick >= 1200 && this.field_70146_Z.nextInt(300) == 0) {
                    this.increaseSize();
                }
            } else {
                this.inertMergeTick = 0;
            }
        }
    }

    private void increaseSize() {
        this.field_70170_p.func_175698_g(this.func_180425_c());
        List foundItems = this.field_70170_p.func_175674_a((Entity)this, boxCraft.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_186662_g(0.1), EntityUtils.selectItemClassInstaceof(ItemRockCrystalBase.class));
        if (foundItems.size() <= 0) {
            ItemStack stack = this.func_92059_d();
            CrystalProperties prop = CrystalProperties.getCrystalProperties(stack);
            int max = stack.func_77973_b() instanceof ItemCelestialCrystal || stack.func_77973_b() instanceof ItemTunedCelestialCrystal ? 900 : 400;
            int grow = this.field_70146_Z.nextInt(90) + 40;
            max = Math.min(prop.getSize() + grow, max);
            CrystalProperties.applyCrystalProperties(stack, new CrystalProperties(max, prop.getPurity(), prop.getCollectiveCapability()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCraftingParticles() {
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(this.field_70165_t + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70163_u + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70161_v + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        p.motion((double)this.field_70146_Z.nextFloat() * 0.05 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.1 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.05 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        p.gravity(0.01);
        p.scale(0.2f).setColor(this.getHighlightColor());
    }

    private boolean canCraft() {
        if (!this.isInLiquidStarlight((Entity)this)) {
            return false;
        }
        List foundEntities = this.field_70170_p.func_175674_a((Entity)this, boxCraft.func_186670_a(this.func_180425_c()), EntityUtils.selectEntities(Entity.class));
        return foundEntities.size() <= 0;
    }
}

