/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import com.google.common.base.Predicates;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.entities.EntityStarlightReacttant;
import hellfirepvp.astralsorcery.common.item.crystal.ToolCrystalProperties;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalSword;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalToolBase;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCrystalTool
extends EntityItem
implements EntityStarlightReacttant {
    private static final AxisAlignedBB boxCraft = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final int TOTAL_MERGE_TIME = 1000;
    private int inertMergeTick = 0;

    public EntityCrystalTool(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityCrystalTool(World worldIn, double x, double y, double z, ItemStack stack) {
        super(worldIn, x, y, z, stack);
    }

    public EntityCrystalTool(World worldIn) {
        super(worldIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70292_b + 5 >= this.lifespan) {
            this.field_70292_b = 0;
        }
        if (Config.craftingLiqCrystalToolGrowth) {
            this.checkIncreaseConditions();
        }
    }

    private void checkIncreaseConditions() {
        if (this.field_70170_p.field_72995_K) {
            if (this.canCraft()) {
                this.spawnCraftingParticles();
            }
        } else {
            if (this.getProperties() == null) {
                this.func_70106_y();
            }
            if (this.canCraft()) {
                ++this.inertMergeTick;
                if (this.inertMergeTick >= 1000 && this.field_70146_Z.nextInt(300) == 0) {
                    this.increaseSize();
                }
            } else {
                this.inertMergeTick = 0;
            }
        }
    }

    @Nullable
    private ToolCrystalProperties getProperties() {
        if (this.func_92059_d() == null || this.func_92059_d().func_77973_b() == null) {
            return null;
        }
        if (this.func_92059_d().func_77973_b() instanceof ItemCrystalToolBase) {
            return ItemCrystalToolBase.getToolProperties(this.func_92059_d());
        }
        if (this.func_92059_d().func_77973_b() instanceof ItemCrystalSword) {
            return ItemCrystalSword.getToolProperties(this.func_92059_d());
        }
        return null;
    }

    private void applyProperties(ToolCrystalProperties properties) {
        if (this.func_92059_d() == null || this.func_92059_d().func_77973_b() == null) {
            return;
        }
        if (this.func_92059_d().func_77973_b() instanceof ItemCrystalToolBase) {
            ItemCrystalToolBase.setToolProperties(this.func_92059_d(), properties);
        }
        if (this.func_92059_d().func_77973_b() instanceof ItemCrystalSword) {
            ItemCrystalSword.setToolProperties(this.func_92059_d(), properties);
        }
    }

    private int getMaxSize() {
        if (this.func_92059_d() == null || this.func_92059_d().func_77973_b() == null) {
            return 900;
        }
        if (this.func_92059_d().func_77973_b() instanceof ItemCrystalToolBase) {
            return ((ItemCrystalToolBase)this.func_92059_d().func_77973_b()).getCrystalCount() * 900;
        }
        if (this.func_92059_d().func_77973_b() instanceof ItemCrystalSword) {
            return 1800;
        }
        return 900;
    }

    private void increaseSize() {
        ToolCrystalProperties prop;
        this.field_70170_p.func_175698_g(this.func_180425_c());
        List foundItems = this.field_70170_p.func_175674_a((Entity)this, boxCraft.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_186662_g(0.1), Predicates.or(EntityUtils.selectItemClassInstaceof(ItemCrystalToolBase.class), EntityUtils.selectItemClassInstaceof(ItemCrystalSword.class)));
        if (foundItems.size() <= 0 && (prop = this.getProperties()) != null) {
            int max = this.getMaxSize();
            int grow = this.field_70146_Z.nextInt(100) + 50;
            max = Math.min(prop.getSize() + grow, max);
            int cut = Math.max(0, prop.getCollectiveCapability() - (this.field_70146_Z.nextInt(20) + 10));
            this.applyProperties(new ToolCrystalProperties(max, prop.getPurity(), cut));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCraftingParticles() {
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(this.field_70165_t + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70163_u + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70161_v + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        p.motion((double)this.field_70146_Z.nextFloat() * 0.02 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.04 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.02 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        p.gravity(0.01);
        p.scale(0.2f).setColor(BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
    }

    private boolean canCraft() {
        if (!this.isInLiquidStarlight((Entity)this)) {
            return false;
        }
        List foundEntities = this.field_70170_p.func_175674_a((Entity)this, boxCraft.func_186670_a(this.func_180425_c()), EntityUtils.selectEntities(Entity.class));
        return foundEntities.size() <= 0;
    }
}

