/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.entities.EntityStarlightReacttant;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemRockCrystalBase;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityItemStardust
extends EntityItem
implements EntityStarlightReacttant {
    private static final AxisAlignedBB boxCraft = new AxisAlignedBB(-0.6, -0.2, -0.6, 0.6, 0.2, 0.6);
    public static final int TOTAL_MERGE_TIME = 600;
    private int inertMergeTick = 0;

    public EntityItemStardust(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityItemStardust(World worldIn) {
        super(worldIn);
    }

    public EntityItemStardust(World worldIn, double x, double y, double z, ItemStack stack) {
        super(worldIn, x, y, z, stack);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70292_b + 5 >= this.lifespan) {
            this.field_70292_b = 0;
        }
        if (Config.craftingLiqCelestialCrystalForm) {
            this.checkMergeConditions();
        }
    }

    private void checkMergeConditions() {
        if (this.field_70170_p.field_72995_K) {
            if (this.canCraft()) {
                this.spawnCraftingParticles();
            }
        } else if (this.canCraft()) {
            ++this.inertMergeTick;
            if (this.inertMergeTick >= 600 && this.field_70146_Z.nextInt(20) == 0) {
                this.buildCelestialCrystals();
            }
        } else {
            this.inertMergeTick = 0;
        }
    }

    private void buildCelestialCrystals() {
        PacketChannel.CHANNEL.sendToAllAround((IMessage)new PktParticleEvent(PktParticleEvent.ParticleEventType.CELESTIAL_CRYSTAL_FORM, this.field_70165_t, this.field_70163_u, this.field_70161_v), PacketChannel.pointFromPos(this.field_70170_p, this.func_180425_c(), 64.0));
        this.field_70170_p.func_175656_a(this.func_180425_c(), BlocksAS.celestialCrystals.func_176223_P());
        --this.func_92059_d().field_77994_a;
        List foundItems = this.field_70170_p.func_175674_a((Entity)this, boxCraft.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_186662_g(0.1), EntityUtils.selectItemClassInstaceof(ItemRockCrystalBase.class));
        if (foundItems.size() > 0) {
            EntityItem ei = (EntityItem)foundItems.get(0);
            ItemStack stack = ei.func_92059_d();
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                ei.func_70106_y();
            } else {
                ei.func_92058_a(stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCraftingParticles() {
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(this.field_70165_t + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70163_u + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70161_v + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        p.motion((double)this.field_70146_Z.nextFloat() * 0.05 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.1 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.05 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
        p.gravity(0.2);
        p.scale(0.2f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnFormationParticles(PktParticleEvent event) {
    }

    private boolean canCraft() {
        if (!this.isInLiquidStarlight((Entity)this)) {
            return false;
        }
        List foundItems = this.field_70170_p.func_175674_a((Entity)this, boxCraft.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v), EntityUtils.selectItemClassInstaceof(ItemRockCrystalBase.class));
        return foundItems.size() > 0;
    }
}

