/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.listener;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.constellation.charge.PlayerChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerkLevelManager;
import hellfirepvp.astralsorcery.common.data.DataWorldSkyHandlers;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationCrafttweaker;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncAlignmentLevels;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncConfig;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandlerNetwork {
    private static final String AS_WORLDHANDLERS_PAYLOAD = "AS|WH";

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayerMP p = (EntityPlayerMP)e.player;
        AstralSorcery.log.info("Synchronizing configuration to " + p.func_70005_c_());
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncConfig(), p);
        PacketChannel.CHANNEL.sendTo((IMessage)new PktSyncAlignmentLevels(ConstellationPerkLevelManager.levelsRequired), p);
        if (Mods.MINETWEAKER.isPresent()) {
            PacketChannel.CHANNEL.sendTo(ModIntegrationCrafttweaker.compileRecipeChangePacket(), p);
        }
        ResearchManager.sendInitClientKnowledge((EntityPlayer)p);
        CelestialGatewaySystem.instance.syncTo((EntityPlayer)p);
        SyncDataHolder.syncAllDataTo((EntityPlayer)p);
    }

    @SubscribeEvent
    public void onLoginEarly(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        List<Integer> dimensions = ((DataWorldSkyHandlers)SyncDataHolder.getDataServer("ActiveWorldSkyHandlers")).getSkyHandlerDimensions();
        buf.writeInt(dimensions.size());
        for (int i : dimensions) {
            buf.writeInt(i);
        }
        event.getManager().func_179290_a((Packet)new SPacketCustomPayload(AS_WORLDHANDLERS_PAYLOAD, buf));
    }

    public static void clientCatchWorldHandlerPayload(SPacketCustomPayload pkt) {
        if (pkt.func_149169_c().equals(AS_WORLDHANDLERS_PAYLOAD)) {
            PacketBuffer buf = pkt.func_180735_b();
            int size = buf.readInt();
            ArrayList<Integer> dimensions = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                dimensions.add(buf.readInt());
            }
            ((DataWorldSkyHandlers)SyncDataHolder.getDataClient("ActiveWorldSkyHandlers")).updateClient(dimensions);
        }
    }

    @SubscribeEvent
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        EntityPlayer player = e.player;
        PlayerChargeHandler.instance.informDisconnect(player);
    }
}

