/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations;

import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.AltarRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.InfusionRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.LightTransmutations;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.RitualMineralis;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.WellRecipe;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncMinetweakerChanges;
import java.util.LinkedList;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.util.IEventHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class ModIntegrationCrafttweaker {
    public static ModIntegrationCrafttweaker instance = new ModIntegrationCrafttweaker();
    public static List<SerializeableRecipe> recipeModifications = new LinkedList<SerializeableRecipe>();

    private ModIntegrationCrafttweaker() {
    }

    public void load() {
        MineTweakerAPI.registerClass(InfusionRecipe.class);
        MineTweakerAPI.registerClass(RitualMineralis.class);
        MineTweakerAPI.registerClass(LightTransmutations.class);
        MineTweakerAPI.registerClass(AltarRecipe.class);
        MineTweakerAPI.registerClass(WellRecipe.class);
        MineTweakerImplementationAPI.onReloadEvent((IEventHandler)AstralRecipeReloadHandlerPre.instance);
        MineTweakerImplementationAPI.onPostReload((IEventHandler)AstralRecipeReloadHandlerPost.instance);
    }

    public static IMessage compileRecipeChangePacket() {
        PktSyncMinetweakerChanges.Compound compound = new PktSyncMinetweakerChanges.Compound();
        for (SerializeableRecipe modification : recipeModifications) {
            PktSyncMinetweakerChanges change = new PktSyncMinetweakerChanges(modification);
            compound.parts.add(change);
        }
        return compound;
    }

    private static class AstralRecipeReloadHandlerPost
    implements IEventHandler<MineTweakerImplementationAPI.ReloadEvent> {
        static AstralRecipeReloadHandlerPost instance = new AstralRecipeReloadHandlerPost();

        private AstralRecipeReloadHandlerPost() {
        }

        public void handle(MineTweakerImplementationAPI.ReloadEvent reloadEvent) {
            CraftingAccessManager.clearModifications();
            for (SerializeableRecipe modification : recipeModifications) {
                modification.applyServer();
            }
            CraftingAccessManager.compile();
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && Loader.instance().hasReachedState(LoaderState.SERVER_ABOUT_TO_START)) {
                PacketChannel.CHANNEL.sendToAll(ModIntegrationCrafttweaker.compileRecipeChangePacket());
            }
        }
    }

    private static class AstralRecipeReloadHandlerPre
    implements IEventHandler<MineTweakerImplementationAPI.ReloadEvent> {
        static AstralRecipeReloadHandlerPre instance = new AstralRecipeReloadHandlerPre();

        private AstralRecipeReloadHandlerPre() {
        }

        public void handle(MineTweakerImplementationAPI.ReloadEvent reloadEvent) {
            recipeModifications.clear();
        }
    }
}

