/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import javax.annotation.Nullable;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseTweaker {
    @Nullable
    public static ItemStack convertToItemStack(IItemStack stack) {
        if (stack == null) {
            return null;
        }
        Object objStack = stack.getInternal();
        if (!(objStack instanceof ItemStack)) {
            MineTweakerAPI.logError((String)("Invalid ItemStack: " + objStack));
            return null;
        }
        return (ItemStack)objStack;
    }

    @Nullable
    public static FluidStack convertToFluidStack(ILiquidStack stack, boolean capAndLimitToBuckets) {
        if (stack == null) {
            return null;
        }
        Object objStack = stack.getInternal();
        if (!(objStack instanceof FluidStack)) {
            MineTweakerAPI.logError((String)("Invalid FluidStack: " + objStack));
            return null;
        }
        FluidStack flStack = (FluidStack)objStack;
        if (capAndLimitToBuckets) {
            flStack.amount = 1000;
        }
        return flStack;
    }

    @Nullable
    public static ItemHandle convertToHandle(IIngredient obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IItemStack) {
            ItemStack ret = BaseTweaker.convertToItemStack((IItemStack)obj);
            if (ret == null) {
                return null;
            }
            return new ItemHandle(ret);
        }
        if (obj instanceof ILiquidStack) {
            FluidStack ret = BaseTweaker.convertToFluidStack((ILiquidStack)obj, true);
            if (ret == null) {
                return null;
            }
            return new ItemHandle(ret);
        }
        if (obj instanceof IOreDictEntry) {
            return new ItemHandle(((IOreDictEntry)obj).getName());
        }
        return null;
    }
}

