/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class AltarRecipeRemove
implements SerializeableRecipe {
    private ItemStack matchOutRemove;
    private TileAltar.AltarLevel level;

    AltarRecipeRemove() {
    }

    public AltarRecipeRemove(ItemStack matchOutRemove, TileAltar.AltarLevel altarLevel) {
        this.matchOutRemove = matchOutRemove;
        this.level = altarLevel;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.ALTAR_REMOVE;
    }

    @Override
    public void read(ByteBuf buf) {
        this.matchOutRemove = ByteBufUtils.readItemStack(buf);
        this.level = TileAltar.AltarLevel.values()[buf.readInt()];
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeItemStack(buf, this.matchOutRemove);
        buf.writeInt(this.level.ordinal());
    }

    @Override
    public void applyServer() {
        CraftingAccessManager.tryRemoveAltarRecipeByOutputAndLevel(this.matchOutRemove, this.level);
    }

    @Override
    public void applyClient() {
        CraftingAccessManager.tryRemoveAltarRecipeByOutputAndLevel(this.matchOutRemove, this.level);
    }
}

