/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import hellfirepvp.astralsorcery.common.crafting.helper.CraftingAccessManager;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class LightTransmutationAdd
implements SerializeableRecipe {
    private ItemStack in;
    private ItemStack out;
    private double cost;

    LightTransmutationAdd() {
    }

    public LightTransmutationAdd(ItemStack in, ItemStack out, double cost) {
        this.in = in;
        this.out = out;
        this.cost = cost;
    }

    @Override
    public SerializeableRecipe.CraftingType getType() {
        return SerializeableRecipe.CraftingType.TRANSMUTE_ADD;
    }

    @Override
    public void read(ByteBuf buf) {
        this.in = ByteBufUtils.readItemStack(buf);
        this.out = ByteBufUtils.readItemStack(buf);
        this.cost = buf.readDouble();
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeItemStack(buf, this.in);
        ByteBufUtils.writeItemStack(buf, this.out);
        buf.writeDouble(this.cost);
    }

    @Override
    public void applyServer() {
        CraftingAccessManager.addMTTransmutation(this.in, this.out, this.cost);
    }

    @Override
    public void applyClient() {
        CraftingAccessManager.addMTTransmutation(this.in, this.out, this.cost);
    }
}

