/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class ItemBlockStorage
extends Item {
    public static void tryStoreBlock(ItemStack storeIn, World w, BlockPos pos) {
        if (w.func_175625_s(pos) != null) {
            return;
        }
        IBlockState stateToStore = w.func_180495_p(pos);
        if (Item.func_150898_a((Block)stateToStore.func_177230_c()) == null) {
            return;
        }
        if (stateToStore.func_185887_b(w, pos) == -1.0f) {
            return;
        }
        NBTTagCompound cmp = NBTHelper.getPersistentData(storeIn);
        cmp.func_74778_a("storedBlock", stateToStore.func_177230_c().getRegistryName().toString());
        cmp.func_74768_a("storedMeta", stateToStore.func_177230_c().func_180651_a(stateToStore));
    }

    @Nullable
    public static ItemStack getStoredStateAsStack(ItemStack stack) {
        IBlockState stored = ItemBlockStorage.getStoredState(stack);
        if (stored == null) {
            return null;
        }
        return ItemUtils.createBlockStack(stored);
    }

    @Nullable
    public static IBlockState getStoredState(ItemStack stack) {
        NBTTagCompound persistentTag = NBTHelper.getPersistentData(stack);
        ResourceLocation blockRes = persistentTag.func_74764_b("storedBlock") ? new ResourceLocation(persistentTag.func_74779_i("storedBlock")) : new ResourceLocation("air");
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(blockRes);
        if (b == null) {
            return null;
        }
        if (Item.func_150898_a((Block)b) == null) {
            return null;
        }
        boolean hasMeta = persistentTag.func_74764_b("storedMeta");
        int meta = persistentTag.func_74762_e("storedMeta");
        if (hasMeta) {
            return b.func_176203_a(meta);
        }
        return b.func_176223_P();
    }
}

