/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.tick.TickManager;
import hellfirepvp.astralsorcery.common.item.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.network.packet.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.util.CropHelper;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.TickTokenizedMap;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColoredLens
extends Item
implements ItemDynamicColor {
    public ItemColoredLens() {
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (ColorType ct : ColorType.values()) {
            subItems.add(new ItemStack(itemIn, 1, ct.getMeta()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        int dmg;
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemColoredLens && (dmg = stack.func_77952_i()) >= 0 && dmg < ColorType.values().length) {
            tooltip.add(I18n.func_135052_a((String)("item.ItemColoredLens.effect." + ColorType.values()[dmg].name().toLowerCase() + ".name"), (Object[])new Object[0]));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileCrystalLens lens;
            int dmg;
            ItemStack inHand = playerIn.func_184586_b(EnumHand.MAIN_HAND);
            ColorType type = null;
            if (inHand != null && inHand.func_77973_b() != null && inHand.func_77973_b() instanceof ItemColoredLens && (dmg = inHand.func_77952_i()) >= 0 && dmg < ColorType.values().length) {
                type = ColorType.values()[dmg];
            }
            if (type != null && (lens = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCrystalLens.class, true)) != null) {
                ColorType oldType = lens.setLensColor(type);
                if (!playerIn.func_184812_l_()) {
                    --inHand.field_77994_a;
                    if (inHand.field_77994_a <= 0) {
                        playerIn.func_184611_a(EnumHand.MAIN_HAND, null);
                    }
                }
                SoundHelper.playSoundAround((SoundEvent)Sounds.clipSwitch, worldIn, (Vec3i)pos, 0.8f, 1.5f);
                if (oldType != null) {
                    ItemUtils.dropItem(worldIn, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ, oldType.asStack());
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public int getColorForItemStack(ItemStack stack, int tintIndex) {
        int dmg = stack.func_77952_i();
        if (dmg < 0 || dmg >= ColorType.values().length) {
            return -1;
        }
        return ColorType.values()[dmg].colorRGB;
    }

    public static enum TargetType {
        ENTITY,
        BLOCK,
        NONE;

    }

    private static class BreakEntry
    implements TickTokenizedMap.TickMapToken<Float> {
        private float breakProgress;
        private final World world;
        private final BlockPos pos;
        private final IBlockState expected;
        private int idleTimeout;

        public BreakEntry(@Nonnull Float value, World world, BlockPos at, IBlockState expectedToBreak) {
            this.breakProgress = value.floatValue();
            this.world = world;
            this.pos = at;
            this.expected = expectedToBreak;
        }

        @Override
        public int getRemainingTimeout() {
            return this.breakProgress <= 0.0f || this.idleTimeout >= 20 ? 0 : 1;
        }

        @Override
        public void tick() {
            ++this.idleTimeout;
        }

        @Override
        public void onTimeout() {
            if (this.breakProgress > 0.0f) {
                return;
            }
            IBlockState nowAt = this.world.func_180495_p(this.pos);
            if (nowAt.func_177230_c().equals(this.expected.func_177230_c()) && nowAt.func_177230_c().func_176201_c(nowAt) == this.expected.func_177230_c().func_176201_c(this.expected)) {
                MiscUtils.breakBlockWithoutPlayer((WorldServer)this.world, this.pos);
            }
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.breakProgress);
        }
    }

    public static enum ColorType {
        FIRE(TargetType.ENTITY, 0xFF7F00, 0.07f),
        BREAK(TargetType.BLOCK, 0xFFDF00, 0.07f),
        GROW(TargetType.BLOCK, 57088, 0.07f),
        DAMAGE(TargetType.ENTITY, 0xDF0000, 0.07f),
        REGEN(TargetType.ENTITY, 0xFF7FBF, 0.07f),
        PUSH(TargetType.ENTITY, 57343, 0.07f),
        SPECTRAL(TargetType.NONE, 8323263, 0.25f);

        private static final Map<Integer, TickTokenizedMap<BlockPos, BreakEntry>> breakMap;
        public final int colorRGB;
        public final Color wrappedColor;
        private final float flowReduction;
        private final TargetType type;

        private ColorType(TargetType type, int colorRGB, float flowReduction) {
            this.type = type;
            this.colorRGB = colorRGB;
            this.wrappedColor = new Color(colorRGB);
            this.flowReduction = flowReduction;
        }

        public TargetType getType() {
            return this.type;
        }

        public float getFlowReduction() {
            return this.flowReduction;
        }

        public String getUnlocalizedName() {
            return this.name().toLowerCase();
        }

        public ItemStack asStack() {
            return new ItemStack((Item)ItemsAS.coloredLens, 1, this.getMeta());
        }

        public int getMeta() {
            return this.ordinal();
        }

        public void onEntityInBeam(Vector3 beamOrigin, Vector3 beamTarget, Entity entity, float percStrength) {
            switch (this) {
                case FIRE: {
                    if (field_77697_d.nextFloat() > percStrength) {
                        return;
                    }
                    if (entity instanceof EntityItem) {
                        ItemStack current = ((EntityItem)entity).func_92059_d();
                        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(current);
                        if (result == null || result.func_77973_b() == null) break;
                        Vector3 entityPos = new Vector3(entity);
                        ItemUtils.dropItemNaturally(entity.func_130014_f_(), entityPos.getX(), entityPos.getY(), entityPos.getZ(), ItemUtils.copyStackWithSize(result, 1));
                        if (current.field_77994_a > 1) {
                            --current.field_77994_a;
                            ((EntityItem)entity).func_92058_a(current);
                            break;
                        }
                        entity.func_70106_y();
                        break;
                    }
                    if (!(entity instanceof EntityLivingBase)) break;
                    entity.func_70015_d(1);
                    break;
                }
                case DAMAGE: {
                    if (!(entity instanceof EntityLivingBase)) {
                        return;
                    }
                    if (field_77697_d.nextFloat() > percStrength) {
                        return;
                    }
                    if (entity instanceof EntityPlayer && entity.func_184102_h() != null && entity.func_184102_h().func_71219_W()) {
                        return;
                    }
                    entity.func_70097_a(CommonProxy.dmgSourceStellar, 6.5f);
                    break;
                }
                case REGEN: {
                    if (!(entity instanceof EntityLivingBase)) {
                        return;
                    }
                    if (field_77697_d.nextFloat() > percStrength) {
                        return;
                    }
                    ((EntityLivingBase)entity).func_70691_i(3.5f);
                    break;
                }
                case PUSH: {
                    if (entity instanceof EntityPlayer || field_77697_d.nextFloat() > percStrength) {
                        return;
                    }
                    Vector3 dir = beamTarget.clone().subtract(beamOrigin).normalize().multiply(0.5f);
                    entity.field_70159_w = Math.min(1.0, entity.field_70179_y + dir.getX());
                    entity.field_70181_x = Math.min(1.0, entity.field_70181_x + dir.getY());
                    entity.field_70179_y = Math.min(1.0, entity.field_70179_y + dir.getZ());
                }
            }
        }

        public void onBlockOccupyingBeam(World world, BlockPos at, IBlockState state, float percStrength) {
            switch (this) {
                case BREAK: {
                    float hardness = state.func_185887_b(world, at);
                    if (hardness < 0.0f) {
                        return;
                    }
                    this.addProgress(world, at, hardness *= 1.5f, percStrength * 4.0f);
                    PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.EffectType.BEAM_BREAK, at);
                    pkt.data = Block.func_176210_f((IBlockState)state);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)pkt, PacketChannel.pointFromPos(world, at, 16.0));
                    break;
                }
                case GROW: {
                    if (world.field_73012_v.nextFloat() > percStrength) {
                        return;
                    }
                    CropHelper.GrowablePlant plant = CropHelper.wrapPlant(world, at);
                    if (plant == null) break;
                    plant.tryGrow(world, world.field_73012_v);
                    PktParticleEvent packet = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)at);
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)packet, PacketChannel.pointFromPos(world, at, 16.0));
                }
            }
        }

        private void addProgress(World world, BlockPos pos, float expectedHardness, float percStrength) {
            BreakEntry breakProgress;
            TickTokenizedMap<Object, BreakEntry> map = breakMap.get(world.field_73011_w.getDimension());
            if (map == null) {
                map = new TickTokenizedMap(TickEvent.Type.SERVER, new TickEvent.Type[0]);
                TickManager.getInstance().register(map);
                breakMap.put(world.field_73011_w.getDimension(), map);
            }
            if ((breakProgress = (BreakEntry)map.get(pos)) == null) {
                breakProgress = new BreakEntry(Float.valueOf(expectedHardness), world, pos, world.func_180495_p(pos));
                map.put(pos, breakProgress);
            }
            BreakEntry breakEntry = breakProgress;
            breakEntry.breakProgress = breakEntry.breakProgress - percStrength;
            breakProgress.idleTimeout = 0;
        }

        @SideOnly(value=Side.CLIENT)
        public static void blockBreakAnimation(PktPlayEffect pktPlayEffect) {
            RenderingUtils.playBlockBreakParticles(pktPlayEffect.pos, Block.func_176220_d((int)pktPlayEffect.data));
        }

        static {
            breakMap = new HashMap<Integer, TickTokenizedMap<BlockPos, BreakEntry>>();
        }
    }
}

