/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.crystal;

import hellfirepvp.astralsorcery.common.data.research.EnumGatedKnowledge;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class CrystalProperties {
    private static final Random rand = new Random();
    public static final int MAX_SIZE_ROCK = 400;
    public static final int MAX_SIZE_CELESTIAL = 900;
    private static final CrystalProperties MAXED_ROCK_PROPERTIES = new CrystalProperties(400, 100, 100);
    private static final CrystalProperties MAXED_CELESTIAL_PROPERTIES = new CrystalProperties(900, 100, 100);
    protected int size;
    protected int purity;
    protected int collectiveCapability;

    public CrystalProperties(int size, int purity, int collectiveCapability) {
        this.size = size;
        this.purity = purity;
        this.collectiveCapability = collectiveCapability;
    }

    public int getSize() {
        return this.size;
    }

    public int getPurity() {
        return this.purity;
    }

    public int getCollectiveCapability() {
        return this.collectiveCapability;
    }

    public static CrystalProperties readFromNBT(NBTTagCompound compound) {
        CrystalProperties prop = new CrystalProperties(0, 0, 0);
        prop.size = compound.func_74762_e("size");
        prop.purity = compound.func_74762_e("purity");
        prop.collectiveCapability = compound.func_74762_e("collect");
        return prop;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("size", this.size);
        compound.func_74768_a("purity", this.purity);
        compound.func_74768_a("collect", this.collectiveCapability);
    }

    public static CrystalProperties createStructural() {
        int size = Math.min(400, 200 + rand.nextInt(200));
        int purity = 60 + rand.nextInt(41);
        int collect = 45 + rand.nextInt(56);
        return new CrystalProperties(size, purity, collect);
    }

    public static CrystalProperties createRandomRock() {
        int size = Math.max(1, (rand.nextInt(400) + rand.nextInt(400)) / 2);
        int purity = (rand.nextInt(101) + rand.nextInt(101)) / 2;
        int collect = 5 + rand.nextInt(26);
        return new CrystalProperties(size, purity, collect);
    }

    public static CrystalProperties createRandomCelestial() {
        int size = Math.max(1, (rand.nextInt(900) + rand.nextInt(900)) / 2);
        int purity = 40 + rand.nextInt(61);
        int collect = 50 + rand.nextInt(26);
        return new CrystalProperties(size, purity, collect);
    }

    public static CrystalProperties getMaxRockProperties() {
        return MAXED_ROCK_PROPERTIES;
    }

    public static CrystalProperties getMaxCelestialProperties() {
        return MAXED_CELESTIAL_PROPERTIES;
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Boolean> addPropertyTooltip(CrystalProperties prop, List<String> tooltip, int maxSize) {
        return CrystalProperties.addPropertyTooltip(prop, tooltip, Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54), maxSize);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Boolean> addPropertyTooltip(CrystalProperties prop, List<String> tooltip, boolean extended, int maxSize) {
        return CrystalProperties.addPropertyTooltip(prop, tooltip, extended, ResearchManager.clientProgress.getTierReached(), maxSize);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Boolean> addPropertyTooltip(CrystalProperties prop, List<String> tooltip, boolean extended, ProgressionTier tier, int maxSize) {
        if (prop != null) {
            if (extended) {
                boolean missing = false;
                if (EnumGatedKnowledge.CRYSTAL_SIZE.canSee(tier)) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"crystal.size", (Object[])new Object[0]) + ": " + (prop.getSize() == maxSize ? TextFormatting.GOLD : TextFormatting.BLUE) + prop.getSize());
                } else {
                    missing = true;
                }
                if (EnumGatedKnowledge.CRYSTAL_PURITY.canSee(tier)) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"crystal.purity", (Object[])new Object[0]) + ": " + (prop.getPurity() == 100 ? TextFormatting.GOLD : TextFormatting.BLUE) + prop.getPurity() + "%");
                } else {
                    missing = true;
                }
                if (EnumGatedKnowledge.CRYSTAL_COLLECT.canSee(tier)) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"crystal.collectivity", (Object[])new Object[0]) + ": " + (prop.getCollectiveCapability() == 100 ? TextFormatting.GOLD : TextFormatting.BLUE) + prop.getCollectiveCapability() + "%");
                } else {
                    missing = true;
                }
                if (missing) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"progress.missing.knowledge", (Object[])new Object[0]));
                }
                return Optional.of(missing);
            }
            tooltip.add(TextFormatting.DARK_GRAY + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"misc.moreInformation", (Object[])new Object[0]));
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Nullable
    public CrystalProperties grindCopy(Random rand) {
        CrystalProperties copy = new CrystalProperties(this.size, this.purity, this.collectiveCapability);
        int grind = 7 + rand.nextInt(5);
        double purity = (double)this.purity / 100.0;
        if (purity <= 0.4) {
            purity = 0.4;
        }
        for (int j = 0; j < (this.size > 300 ? 5 : 2); ++j) {
            if (!(purity <= (double)rand.nextFloat())) continue;
            grind += grind;
        }
        int collectToAdd = 3 + rand.nextInt(4);
        copy.size = this.size - grind;
        copy.collectiveCapability = Math.min(100, this.collectiveCapability + collectToAdd);
        if (copy.size <= 0) {
            return null;
        }
        return copy;
    }

    public static void applyCrystalProperties(ItemStack stack, CrystalProperties properties) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        NBTTagCompound crystalProp = new NBTTagCompound();
        crystalProp.func_74768_a("size", properties.getSize());
        crystalProp.func_74768_a("purity", properties.getPurity());
        crystalProp.func_74768_a("collectiveCapability", properties.getCollectiveCapability());
        cmp.func_74782_a("crystalProperties", (NBTBase)crystalProp);
    }

    public static CrystalProperties getCrystalProperties(ItemStack stack) {
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        if (!cmp.func_74764_b("crystalProperties")) {
            return null;
        }
        NBTTagCompound prop = cmp.func_74775_l("crystalProperties");
        Integer size = prop.func_74762_e("size");
        Integer purity = prop.func_74762_e("purity");
        Integer colCap = prop.func_74762_e("collectiveCapability");
        return new CrystalProperties(size, purity, colCap);
    }

    public String toString() {
        return "CrystalProperties={Size=" + this.size + ", Purity=" + this.purity + ",Cutting=" + this.collectiveCapability + "}";
    }
}

