/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.block.EffectTranslucentFallingBlock;
import hellfirepvp.astralsorcery.common.item.tool.ChargedCrystalToolBase;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalPickaxe;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktOreScan;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import hellfirepvp.astralsorcery.common.util.struct.OreDiscoverer;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChargedCrystalPickaxe
extends ItemCrystalPickaxe
implements ChargedCrystalToolBase {
    private static int idx = 0;

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && this.scanForOres(worldIn, playerIn)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND && this.scanForOres(worldIn, playerIn)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean scanForOres(World world, EntityPlayer player) {
        if (!world.field_72995_K && player instanceof EntityPlayerMP && !MiscUtils.isPlayerFakeMP((EntityPlayerMP)player) && !player.func_184811_cZ().func_185141_a((Item)ItemsAS.chargedCrystalPickaxe)) {
            Thread tr = new Thread(() -> {
                BlockArray foundOres = OreDiscoverer.startSearch(world, new Vector3((Entity)player), 14);
                if (!foundOres.isEmpty()) {
                    LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                    BlockPos plPos = player.func_180425_c();
                    for (BlockPos pos : foundOres.getPattern().keySet()) {
                        if (!(pos.func_177951_i((Vec3i)plPos) < 350.0)) continue;
                        positions.add(pos);
                    }
                    PktOreScan scan = new PktOreScan(positions, true);
                    PacketChannel.CHANNEL.sendTo((IMessage)scan, (EntityPlayerMP)player);
                }
            });
            tr.setName("Ore Scan " + idx);
            ++idx;
            tr.start();
            if (!ChargedCrystalToolBase.tryRevertMainHand(player, player.func_184614_ca())) {
                player.func_184811_cZ().func_185145_a((Item)ItemsAS.chargedCrystalPickaxe, 150);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playClientEffects(Collection<BlockPos> positions, boolean tumble) {
        for (BlockPos at : positions) {
            Vector3 atPos = new Vector3(at).add(0.5, 0.5, 0.5);
            atPos.add(field_77697_d.nextFloat() - field_77697_d.nextFloat(), field_77697_d.nextFloat() - field_77697_d.nextFloat(), field_77697_d.nextFloat() - field_77697_d.nextFloat());
            IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(at);
            EffectTranslucentFallingBlock bl = EffectHandler.getInstance().translucentFallingBlock(atPos, state);
            bl.setDisableDepth(true).setScaleFunction(new EntityComplexFX.ScaleFunction.Shrink<EffectTranslucentFallingBlock>());
            bl.setMotion(0.0, 0.03, 0.0).setAlphaFunction(EntityComplexFX.AlphaFunction.PYRAMID);
            if (tumble) {
                bl.tumble();
            }
            bl.setMaxAge(35);
        }
    }

    @Override
    public Item getInertVariant() {
        return ItemsAS.crystalPickaxe;
    }
}

