/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.RockCrystalBuffer;
import hellfirepvp.astralsorcery.common.item.base.ISpecialInteractItem;
import hellfirepvp.astralsorcery.common.item.base.IWandInteract;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWand
extends Item
implements ISpecialInteractItem {
    private static final Random rand = new Random();

    public ItemWand() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!isSelected) {
            boolean bl = isSelected = entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184592_cb() == stack;
        }
        if (!worldIn.field_72995_K && isSelected && worldIn.func_82737_E() % 20L == 0L && entityIn instanceof EntityPlayerMP) {
            RockCrystalBuffer buf = (RockCrystalBuffer)WorldCacheManager.getOrLoadData(worldIn, WorldCacheManager.SaveKey.ROCK_CRYSTAL);
            ChunkPos pos = new ChunkPos(entityIn.func_180425_c());
            List<BlockPos> posList = buf.collectPositions(pos, 4);
            for (BlockPos rPos : posList) {
                IBlockState state = worldIn.func_180495_p(rPos);
                if (!(state.func_177230_c() instanceof BlockCustomOre) || state.func_177229_b(BlockCustomOre.ORE_TYPE) != BlockCustomOre.OreType.ROCK_CRYSTAL) {
                    buf.removeOre(rPos);
                    continue;
                }
                BlockPos p = worldIn.func_175672_r(rPos).func_177984_a();
                double dstr = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(worldIn);
                if (!(dstr > 1.0E-4)) continue;
                PktParticleEvent pkt = new PktParticleEvent(PktParticleEvent.ParticleEventType.WAND_CRYSTAL_HIGHLIGHT, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)entityIn);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void highlightEffects(PktParticleEvent event) {
        BlockPos pos = event.getVec().toBlockPos();
        double x = (float)pos.func_177958_n() + rand.nextFloat() * (float)(rand.nextBoolean() ? 2 : -2);
        double y = (float)pos.func_177956_o() + rand.nextFloat() * (float)(rand.nextBoolean() ? 2 : -2);
        double z = (float)pos.func_177952_p() + rand.nextFloat() * (float)(rand.nextBoolean() ? 2 : -2);
        double velX = rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1);
        double velY = rand.nextFloat() * 0.3f;
        double velZ = rand.nextFloat() * 0.01f * (float)(rand.nextBoolean() ? 1 : -1);
        double dstr = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution((World)Minecraft.func_71410_x().field_71441_e);
        for (int i = 0; i < 10; ++i) {
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(x, y, z);
            particle.setColor(BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
            particle.motion(velX * (0.2 + 0.8 * (double)rand.nextFloat()), velY * (0.4 + 0.6 * (double)rand.nextFloat()), velZ * (0.2 + 0.8 * (double)rand.nextFloat()));
            particle.scale(0.7f).setMaxAge(70);
            particle.enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).setAlphaMultiplier((float)(150.0 * dstr / 255.0));
        }
    }

    @Override
    public boolean needsSpecialHandling(World world, BlockPos at, EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Override
    public void onRightClick(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, EnumHand hand, ItemStack stack) {
        IBlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof IWandInteract) {
            ((IWandInteract)b).onInteract(world, pos, entityPlayer, side, entityPlayer.func_70093_af());
            return;
        }
        IWandInteract wandTe = MiscUtils.getTileAt((IBlockAccess)world, pos, IWandInteract.class, true);
        if (wandTe != null) {
            wandTe.onInteract(world, pos, entityPlayer, side, entityPlayer.func_70093_af());
        }
    }
}

